/*
 * Decompiled with CFR 0.152.
 */
package mikera.gui;

import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import mikera.gui.Frames;
import mikera.gui.JIcon;
import mikera.util.Rand;

public class ImageUtils {
    public static BufferedImage loadImage(String filename) {
        try {
            URL imageURL = Thread.currentThread().getContextClassLoader().getResource(filename);
            return ImageIO.read(imageURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage loadImage(URL imageURL) {
        BufferedImage image;
        try {
            image = ImageIO.read(imageURL);
        }
        catch (IOException e) {
            throw new Error("Image read failed", e);
        }
        return image;
    }

    public static int randomColour() {
        return -16777216 + 65536 * Rand.r((int)256) + 256 * Rand.r((int)256) + Rand.r((int)256);
    }

    public static Frame display(BufferedImage image) {
        return Frames.display(new JIcon(image));
    }

    public static Frame display(BufferedImage image, String s) {
        return Frames.display(new JIcon(image), s);
    }
}

