/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.geom;

import mikera.vectorz.AVector;
import mikera.vectorz.Vector3;

public final class BoundBox
implements Cloneable {
    public final Vector3 lower;
    public final Vector3 upper;

    public BoundBox(BoundBox bb) {
        this.lower = bb.lower.clone();
        this.upper = bb.upper.clone();
    }

    public BoundBox() {
        this.lower = new Vector3(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.upper = new Vector3(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    private void include(double lx, double ly, double lz, double ux, double uy, double uz) {
        if (lx < this.lower.x) {
            this.lower.x = lx;
        }
        if (ly < this.lower.y) {
            this.lower.y = ly;
        }
        if (lz < this.lower.z) {
            this.lower.z = lz;
        }
        if (ux > this.upper.x) {
            this.upper.x = ux;
        }
        if (uy > this.upper.y) {
            this.upper.y = uy;
        }
        if (uz > this.upper.z) {
            this.upper.z = uz;
        }
    }

    public void include(double x, double y, double z) {
        if (x < this.lower.x) {
            this.lower.x = x;
        }
        if (y < this.lower.y) {
            this.lower.y = y;
        }
        if (z < this.lower.z) {
            this.lower.z = z;
        }
        if (x > this.upper.x) {
            this.upper.x = x;
        }
        if (y > this.upper.y) {
            this.upper.y = y;
        }
        if (z > this.upper.z) {
            this.upper.z = z;
        }
    }

    public void includeX(double x) {
        if (x < this.lower.x) {
            this.lower.x = x;
        }
        if (x > this.upper.x) {
            this.upper.x = x;
        }
    }

    public void includeY(double y) {
        if (y < this.lower.y) {
            this.lower.y = y;
        }
        if (y > this.upper.y) {
            this.upper.y = y;
        }
    }

    public void includeZ(double z) {
        if (z < this.lower.z) {
            this.lower.z = z;
        }
        if (z > this.upper.z) {
            this.upper.z = z;
        }
    }

    public BoundBox(BoundBox bb, double margin) {
        Vector3 a = bb.lower;
        this.lower = new Vector3(a.x - margin, a.y - margin, a.z - margin);
        Vector3 b = bb.upper;
        this.upper = new Vector3(b.x + margin, b.y + margin, b.z + margin);
    }

    public BoundBox(Vector3 a, double margin) {
        this.lower = new Vector3(a.x - margin, a.y - margin, a.z - margin);
        this.upper = new Vector3(a.x + margin, a.y + margin, a.z + margin);
    }

    public BoundBox(AVector a) {
        if (a instanceof Vector3) {
            Vector3 v = (Vector3)a;
            this.lower = v.clone();
            this.upper = v.clone();
        } else {
            double x = a.get(0);
            double y = a.get(1);
            double z = a.get(2);
            this.lower = new Vector3(x, y, z);
            this.upper = new Vector3(x, y, z);
        }
    }

    public BoundBox(AVector a, AVector b) {
        this(a);
        this.include(b);
    }

    public void include(AVector a) {
        if (a instanceof Vector3) {
            this.include((Vector3)a);
            return;
        }
        this.include(a.get(0), a.get(1), a.get(2));
    }

    public void include(Vector3 a) {
        this.include(a.x, a.y, a.z);
    }

    public void include(Vector3 lower, Vector3 upper) {
        this.include(lower.x, lower.y, lower.z, upper.x, upper.y, upper.z);
    }

    public void include(BoundBox bb) {
        this.include(bb.upper, bb.lower);
    }

    public void setToPoint(Vector3 a) {
        this.lower.x = this.upper.x = a.x;
        this.lower.y = this.upper.y = a.y;
        this.lower.z = this.upper.z = a.z;
    }

    public BoundBox clone() {
        return new BoundBox(this);
    }

    public boolean equals(Object o) {
        if (o instanceof BoundBox) {
            return this.equals((BoundBox)o);
        }
        return false;
    }

    public boolean equals(BoundBox b) {
        return this.lower.equals((Object)b.lower) && this.upper.equals((Object)b.upper);
    }

    public boolean contains(double x, double y, double z) {
        return x >= this.lower.x && y >= this.lower.y && z >= this.lower.z && x <= this.upper.x && y <= this.upper.y && z <= this.upper.z;
    }

    public boolean contains(BoundBox bb) {
        return this.contains(bb.lower) && this.contains(bb.upper);
    }

    private boolean contains(Vector3 a) {
        return this.contains(a.x, a.y, a.z);
    }

    public int hashCode() {
        return 31 * this.lower.hashCode() + this.upper.hashCode();
    }

    public void includeEverything() {
        this.lower.fill(Double.NEGATIVE_INFINITY);
        this.upper.fill(Double.POSITIVE_INFINITY);
    }

    public void include(Vector3 point, double margin) {
        this.include(point.x - margin, point.y - margin, point.z - margin, point.x + margin, point.y + margin, point.z + margin);
    }

    public String toString() {
        return "BoundBox[lower = " + this.lower.toString() + " , upper = " + this.upper.toString() + "]";
    }
}

