/*
 * Decompiled with CFR 0.152.
 */
package enlight.model.primitive;

import enlight.EnlightError;
import enlight.model.ASceneObject;
import enlight.model.IntersectionInfo;
import enlight.model.primitive.ACompositeObject;
import java.util.Collection;
import mikera.vectorz.Vector3;
import mikera.vectorz.geom.BoundBox;
import mikera.vectorz.geom.Ray;

public final class Union
extends ACompositeObject {
    private final boolean finite;
    private final int count;
    private final ASceneObject[] objects;

    private Union(ASceneObject[] objects) {
        this.objects = objects;
        this.count = objects.length;
        boolean anyInfinite = false;
        for (int i = 0; i < this.count; ++i) {
            if (objects[i].isFinite()) continue;
            anyInfinite = true;
        }
        this.finite = !anyInfinite;
    }

    public static Union of(Collection<ASceneObject> objects) {
        return new Union(objects.toArray(new ASceneObject[objects.size()]));
    }

    @Override
    public boolean isFinite() {
        return this.finite;
    }

    @Override
    public double getSupport(Vector3 normal) {
        if (!this.isFinite()) {
            throw new EnlightError("Can't get support of union of infinite objects!");
        }
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public boolean getIntersection(Ray ray, IntersectionInfo result) {
        boolean found = false;
        for (ASceneObject o : this.objects) {
            if (!o.getIntersection(ray, result)) continue;
            found = true;
        }
        return found;
    }

    @Override
    public void includeInBoundBox(BoundBox b) {
        for (ASceneObject o : this.objects) {
            o.includeInBoundBox(b);
        }
    }
}

