/*
 * Decompiled with CFR 0.152.
 */
package enlight.model.primitive;

import enlight.Key;
import enlight.model.IntersectionInfo;
import enlight.model.primitive.AFinitePrimitive;
import java.util.HashMap;
import java.util.Map;
import mikera.vectorz.Vector3;
import mikera.vectorz.geom.BoundBox;
import mikera.vectorz.geom.Ray;

public class Sphere
extends AFinitePrimitive {
    private final Vector3 centre;
    private final double radius;

    @Override
    public HashMap<Object, Object> getProperties() {
        HashMap<Object, Object> hm = super.getProperties();
        hm.put(Key.TYPE, Key.SPHERE);
        hm.put(Key.CENTRE, this.centre);
        hm.put(Key.RADIUS, this.radius);
        return hm;
    }

    protected Sphere(Sphere old, Map<Object, Object> props) {
        super(old, props);
        this.centre = props.containsKey(Key.CENTRE) ? props.get(Key.CENTRE) : old.centre;
        this.radius = ((Number)(props.containsKey(Key.RADIUS) ? props.get(Key.RADIUS) : Double.valueOf(old.radius))).doubleValue();
    }

    @Override
    public Sphere with(Map<Object, Object> props) {
        return new Sphere(this, props);
    }

    public Sphere(Vector3 centre, double radius) {
        this.centre = centre;
        this.radius = radius;
    }

    @Override
    public double getSupport(Vector3 normal) {
        return normal.dotProduct(this.centre) + this.radius;
    }

    @Override
    public boolean getIntersection(Ray ray, IntersectionInfo result) {
        Vector3 c = new Vector3(this.centre);
        c.sub(ray.origin);
        double centreDist = ray.direction.dotProduct(c);
        double disc = centreDist * centreDist - c.magnitudeSquared() + this.radius * this.radius;
        if (disc <= 0.0) {
            return false;
        }
        double rootDisc = Math.sqrt(disc);
        if (ray.end <= centreDist - rootDisc) {
            return false;
        }
        if (ray.start >= centreDist + rootDisc) {
            return false;
        }
        double collDist = centreDist - rootDisc;
        if (ray.start >= collDist) {
            result.interior = true;
            collDist = centreDist + rootDisc;
        } else {
            result.interior = false;
        }
        assert (ray.start <= collDist);
        result.intersectionObject = this;
        result.intersectionPoint.set(ray.direction);
        result.intersectionPoint.multiply(collDist);
        result.surfaceNormal.set(result.intersectionPoint);
        result.surfaceNormal.sub(c);
        result.surfaceNormal.normalise();
        if (result.interior) {
            result.surfaceNormal.multiply(-1.0);
        }
        result.intersectionPoint.add(ray.origin);
        result.intersectionDistance = collDist;
        ray.end = collDist;
        return true;
    }

    @Override
    public void includeInBoundBox(BoundBox b) {
        b.include(this.centre, this.radius);
    }
}

