/*
 * Decompiled with CFR 0.152.
 */
package enlight.model.primitive;

import enlight.Key;
import enlight.model.ASceneObject;
import enlight.model.IntersectionInfo;
import enlight.model.Utils;
import java.util.HashMap;
import java.util.Map;
import mikera.transformz.ATransform;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector3;
import mikera.vectorz.geom.Ray;

public abstract class APrimitive
extends ASceneObject {
    private final ATransform colourFunction;

    @Override
    public abstract boolean isFinite();

    public APrimitive() {
        this.colourFunction = Utils.DEFAULT_RGB_FUNCTION;
    }

    protected APrimitive(APrimitive old, Map<Object, Object> props) {
        super(old, props);
        this.colourFunction = props.containsKey(Key.COLOUR) ? props.get(Key.COLOUR) : old.colourFunction;
    }

    public void getPigment(Vector3 position, Vector3 colourOut) {
        this.colourFunction.transform((AVector)position, (AVector)colourOut);
    }

    @Override
    public HashMap<Object, Object> getProperties() {
        HashMap<Object, Object> hm = super.getProperties();
        hm.put(Key.COLOUR, this.colourFunction);
        return hm;
    }

    @Override
    public abstract double getSupport(Vector3 var1);

    @Override
    public abstract boolean getIntersection(Ray var1, IntersectionInfo var2);
}

