/*
 * Decompiled with CFR 0.152.
 */
package enlight.maths;

public final class Point3D {
    public double x;
    public double y;
    public double z;
    private static final double APPROX_EPSILON = 1.0E-4;

    public Point3D() {
    }

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3D(Point3D a) {
        this(a.x, a.y, a.z);
    }

    public void add(Point3D a) {
        this.x += a.x;
        this.y += a.y;
        this.z += a.z;
    }

    public void addMultiple(Point3D a, double factor) {
        this.x += a.x * factor;
        this.y += a.y * factor;
        this.z += a.z * factor;
    }

    public void add(double dx, double dy, double dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public void addMultiple(double dx, double dy, double dz, double factor) {
        this.x += dx * factor;
        this.y += dy * factor;
        this.z += dz * factor;
    }

    public void sub(Point3D a) {
        this.x -= a.x;
        this.y -= a.y;
        this.z -= a.z;
    }

    public void sub(double dx, double dy, double dz) {
        this.x -= dx;
        this.y -= dy;
        this.z -= dz;
    }

    public void mul(double factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
    }

    public void normalize() {
        double len = this.length();
        if (len == 0.0) {
            this.set(0.0, 0.0, 0.0);
            return;
        }
        double factor = 1.0 / len;
        this.mul(factor);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(Point3D a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
    }

    public double dot(Point3D a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public void cross(Point3D a) {
        double tx = this.y * a.z - this.z * a.y;
        double ty = this.z * a.x - this.x * a.z;
        double tz = this.x * a.y - this.y * a.x;
        this.x = tx;
        this.y = ty;
        this.z = tz;
    }

    public boolean equals(Object a) {
        if (!(a instanceof Point3D)) {
            return false;
        }
        return this.equals((Point3D)a);
    }

    public boolean equals(Point3D a) {
        return this.x == a.x && this.y == a.y && this.z == a.z;
    }

    public String toString() {
        return "Point3D [" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public boolean approxEquals(Point3D a) {
        if (this.x < a.x - 1.0E-4 || this.x > a.x + 1.0E-4) {
            return false;
        }
        if (this.y < a.y - 1.0E-4 || this.y > a.y + 1.0E-4) {
            return false;
        }
        return !(this.z < a.z - 1.0E-4) && !(this.z > a.z + 1.0E-4);
    }
}

