/*
 * Decompiled with CFR 0.152.
 */
package bpsm.edn.printer;

import bpsm.edn.EdnException;
import bpsm.edn.EdnIOException;
import bpsm.edn.Keyword;
import bpsm.edn.Symbol;
import bpsm.edn.Tag;
import bpsm.edn.TaggedValue;
import bpsm.edn.parser.Parser;
import bpsm.edn.parser.inst.InstantUtils;
import bpsm.edn.printer.PrintFn;
import bpsm.edn.printer.Printer;
import bpsm.edn.printer.Util;
import bpsm.edn.protocols.Function;
import bpsm.edn.protocols.Protocol;
import bpsm.edn.protocols.Protocols;
import bpsm.edn.util.CharClassify;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;

public class Printers {
    public static Printer newPrinter(Writer writer) {
        return Printers.newPrinter(Printers.defaultPrinterConfig(), writer);
    }

    public static Printer newPrinter(final Printer.Config cfg, final Appendable out) {
        return new Printer(){
            int softspace = 0;

            public void close() {
                if (out instanceof Writer) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (IOException e) {
                        throw new EdnIOException(e);
                    }
                }
            }

            public Printer append(CharSequence csq) {
                try {
                    if (this.softspace > 1 && csq.length() > 0 && !CharClassify.isWhitespace(csq.charAt(0))) {
                        out.append(' ');
                    }
                    this.softspace = 0;
                    out.append(csq);
                    return this;
                }
                catch (IOException e) {
                    throw new EdnIOException(e);
                }
            }

            public Printer append(char c) {
                try {
                    if (this.softspace > 1 && !CharClassify.isWhitespace(c)) {
                        out.append(' ');
                    }
                    this.softspace = 0;
                    out.append(c);
                    return this;
                }
                catch (IOException e) {
                    throw new EdnIOException(e);
                }
            }

            public Printer printValue(Object ednValue) {
                Function printFn = cfg.getPrintFn(ednValue);
                if (printFn == null) {
                    throw new EdnException(String.format("Don't know how to write '%s' of type '%s'", ednValue, Util.getClassOrNull(ednValue)));
                }
                printFn.eval(ednValue, this);
                return this;
            }

            public Printer softspace() {
                ++this.softspace;
                return this;
            }
        };
    }

    private static Protocol.Builder defaultProtocolBuilder() {
        Protocol.Builder protocolBuilder = Protocols.builder("print").put(null, Printers.writeNullFn()).put(List.class, Printers.writeListFn()).put(Map.class, Printers.writeMapFn()).put(Set.class, Printers.writeSetFn()).put(Keyword.class, Printers.writeKeywordFn()).put(Symbol.class, Printers.writeSymbolFn()).put(CharSequence.class, Printers.writeCharSequenceFn()).put(Character.class, Printers.writeCharacterFn()).put(Boolean.class, Printers.writeBooleanFn()).put(Byte.class, Printers.writeLongValueFn()).put(Short.class, Printers.writeLongValueFn()).put(Integer.class, Printers.writeLongValueFn()).put(Long.class, Printers.writeLongValueFn()).put(BigInteger.class, Printers.writeBigIntegerFn()).put(Float.class, Printers.writeDoubleValueFn()).put(Double.class, Printers.writeDoubleValueFn()).put(BigDecimal.class, Printers.writeBigDecimalFn()).put(UUID.class, Printers.writeUuidFn()).put(Date.class, Printers.writeDateFn()).put(Timestamp.class, Printers.writeTimestampFn()).put(GregorianCalendar.class, Printers.writeCalendarFn()).put(TaggedValue.class, Printers.writeTaggedValueFn()).put(Tag.class, Printers.writeTagFn());
        return protocolBuilder;
    }

    public static Printer.Config.Builder newPrinterConfigBuilder() {
        return new Printer.Config.Builder(){
            Protocol.Builder protocolBuilder = Printers.access$000();

            public Printer.Config.Builder bind(Class ednValueClass, Function printFn) {
                this.protocolBuilder.put(ednValueClass, printFn);
                return this;
            }

            public Printer.Config build() {
                return new Printer.Config(){
                    Protocol protocol;
                    {
                        this.protocol = protocolBuilder.build();
                    }

                    public Function getPrintFn(Object ednValue) {
                        return this.protocol.lookup(Util.getClassOrNull(ednValue));
                    }
                };
            }
        };
    }

    public static Printer.Config defaultPrinterConfig() {
        return Printers.newPrinterConfigBuilder().build();
    }

    public static String printString(Printer.Config cfg, Object ednValue) {
        StringBuilder sb = new StringBuilder();
        Printers.newPrinter(cfg, sb).printValue(ednValue).close();
        return sb.toString();
    }

    public static String printString(Object ednValue) {
        return Printers.printString(Printers.defaultPrinterConfig(), ednValue);
    }

    static Function writeNullFn() {
        return new PrintFn<Void>(){

            @Override
            protected void eval(Void self, Printer writer) {
                writer.softspace().append("nil").softspace();
            }
        };
    }

    static Function writeListFn() {
        return new PrintFn<List<?>>(){

            @Override
            protected void eval(List<?> self, Printer writer) {
                boolean vec = self instanceof RandomAccess;
                writer.append(vec ? (char)'[' : '(');
                for (Object o : self) {
                    writer.printValue(o);
                }
                writer.append(vec ? (char)']' : ')');
            }
        };
    }

    static Function writeSetFn() {
        return new PrintFn<Set<?>>(){

            @Override
            protected void eval(Set<?> self, Printer writer) {
                writer.append("#{");
                for (Object o : self) {
                    writer.printValue(o);
                }
                writer.append('}');
            }
        };
    }

    static Function writeMapFn() {
        return new PrintFn<Map<?, ?>>(){

            @Override
            protected void eval(Map<?, ?> self, Printer writer) {
                writer.append('{');
                for (Map.Entry<?, ?> p : self.entrySet()) {
                    writer.printValue(p.getKey()).printValue(p.getValue());
                }
                writer.append('}');
            }
        };
    }

    static Function writeKeywordFn() {
        return new PrintFn<Keyword>(){

            @Override
            protected void eval(Keyword self, Printer writer) {
                writer.softspace().append(self.toString()).softspace();
            }
        };
    }

    static Function writeSymbolFn() {
        return new PrintFn<Symbol>(){

            @Override
            protected void eval(Symbol self, Printer writer) {
                writer.softspace().append(self.toString()).softspace();
            }
        };
    }

    static Function writeTaggedValueFn() {
        return new PrintFn<TaggedValue>(){

            @Override
            protected void eval(TaggedValue self, Printer writer) {
                writer.printValue(self.getTag()).printValue(self.getValue());
            }
        };
    }

    static Function writeBooleanFn() {
        return new PrintFn<Boolean>(){

            @Override
            protected void eval(Boolean self, Printer writer) {
                writer.softspace().append(self != false ? "true" : "false").softspace();
            }
        };
    }

    static Function writeCharSequenceFn() {
        return new PrintFn<CharSequence>(){

            @Override
            protected void eval(CharSequence self, Printer writer) {
                writer.append('\"');
                block10: for (int i = 0; i < self.length(); ++i) {
                    char c = self.charAt(i);
                    switch (c) {
                        case '\"': {
                            writer.append('\\').append('\"');
                            continue block10;
                        }
                        case '\b': {
                            writer.append('\\').append('b');
                            continue block10;
                        }
                        case '\t': {
                            writer.append('\\').append('t');
                            continue block10;
                        }
                        case '\n': {
                            writer.append('\\').append('n');
                            continue block10;
                        }
                        case '\r': {
                            writer.append('\\').append('r');
                            continue block10;
                        }
                        case '\f': {
                            writer.append('\\').append('f');
                            continue block10;
                        }
                        case '\'': {
                            writer.append('\\').append('\'');
                            continue block10;
                        }
                        case '\\': {
                            writer.append('\\').append('\\');
                            continue block10;
                        }
                        default: {
                            writer.append(c);
                        }
                    }
                }
                writer.append('\"');
            }
        };
    }

    static Function writeCharacterFn() {
        return new PrintFn<Character>(){

            @Override
            protected void eval(Character self, Printer writer) {
                char c = self.charValue();
                if (!CharClassify.isWhitespace(c)) {
                    writer.append('\\').append(c);
                } else {
                    switch (c) {
                        case '\b': {
                            writer.append("\\backspace");
                            break;
                        }
                        case '\t': {
                            writer.append("\\tab");
                            break;
                        }
                        case '\n': {
                            writer.append("\\newline");
                            break;
                        }
                        case '\r': {
                            writer.append("\\return");
                            break;
                        }
                        case '\f': {
                            writer.append("\\formfeed");
                            break;
                        }
                        case ' ': {
                            writer.append("\\space");
                            break;
                        }
                        default: {
                            throw new EdnException("Whitespace character 0x" + Integer.toHexString(c) + " is unsupported.");
                        }
                    }
                }
                writer.softspace();
            }
        };
    }

    static Function writeLongValueFn() {
        return new PrintFn<Number>(){

            @Override
            protected void eval(Number self, Printer writer) {
                writer.softspace().append(String.valueOf(self.longValue())).softspace();
            }
        };
    }

    static Function writeBigIntegerFn() {
        return new PrintFn<BigInteger>(){

            @Override
            protected void eval(BigInteger self, Printer writer) {
                writer.softspace().append(self.toString()).append('N').softspace();
            }
        };
    }

    static Function writeDoubleValueFn() {
        return new PrintFn<Number>(){

            @Override
            protected void eval(Number self, Printer writer) {
                writer.softspace().append(String.valueOf(self.doubleValue())).softspace();
            }
        };
    }

    static Function writeBigDecimalFn() {
        return new PrintFn<BigDecimal>(){

            @Override
            protected void eval(BigDecimal self, Printer writer) {
                writer.softspace().append(self.toString()).append('M').softspace();
            }
        };
    }

    static Function writeUuidFn() {
        return new PrintFn<UUID>(){

            @Override
            protected void eval(UUID self, Printer writer) {
                writer.printValue(Parser.Config.EDN_UUID).printValue(self.toString());
            }
        };
    }

    static Function writeDateFn() {
        return new PrintFn<Date>(){

            @Override
            protected void eval(Date self, Printer writer) {
                writer.printValue(Parser.Config.EDN_INSTANT).printValue(InstantUtils.dateToString(self));
            }
        };
    }

    static Function writeTimestampFn() {
        return new PrintFn<Timestamp>(){

            @Override
            protected void eval(Timestamp self, Printer writer) {
                writer.printValue(Parser.Config.EDN_INSTANT).printValue(InstantUtils.timestampToString(self));
            }
        };
    }

    static Function writeCalendarFn() {
        return new PrintFn<GregorianCalendar>(){

            @Override
            protected void eval(GregorianCalendar self, Printer writer) {
                writer.printValue(Parser.Config.EDN_INSTANT).printValue(InstantUtils.calendarToString(self));
            }
        };
    }

    static Function writeTagFn() {
        return new PrintFn<Tag>(){

            @Override
            protected void eval(Tag self, Printer writer) {
                writer.softspace().append(self.toString()).softspace();
            }
        };
    }

    static /* synthetic */ Protocol.Builder access$000() {
        return Printers.defaultProtocolBuilder();
    }
}

