/*
 * Decompiled with CFR 0.152.
 */
package bpsm.edn.parser;

import bpsm.edn.EdnException;
import bpsm.edn.EdnIOException;
import bpsm.edn.Tag;
import bpsm.edn.TaggedValue;
import bpsm.edn.parser.CollectionBuilder;
import bpsm.edn.parser.Parser;
import bpsm.edn.parser.Scanner;
import bpsm.edn.parser.TagHandler;
import bpsm.edn.parser.Token;
import java.io.IOException;

class ParserImpl
implements Parser {
    private Parser.Config cfg;
    private Scanner scanner;
    private Object curr;
    private int discard;

    ParserImpl(Parser.Config cfg, Scanner scanner) throws IOException {
        this.scanner = scanner;
        this.curr = scanner.nextToken();
        this.cfg = cfg;
        this.discard = 0;
    }

    public void close() {
        if (this.scanner != null) {
            try {
                this.scanner.close();
            }
            catch (IOException e) {
                throw new EdnIOException(e);
            }
            finally {
                this.scanner = null;
            }
        }
    }

    public Object nextValue() {
        try {
            return this.nextValue0();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (EdnIOException ednIOException) {
                // empty catch block
            }
            throw new EdnIOException(e);
        }
    }

    private Object nextValue0() throws IOException {
        assert (this.discard >= 0);
        if (this.curr instanceof Token) {
            switch ((Token)((Object)this.curr)) {
                case BEGIN_LIST: {
                    this.nextToken();
                    return this.parseIntoCollection(this.cfg.getListFactory(), Token.END_LIST);
                }
                case BEGIN_VECTOR: {
                    this.nextToken();
                    return this.parseIntoCollection(this.cfg.getVectorFactory(), Token.END_VECTOR);
                }
                case BEGIN_SET: {
                    this.nextToken();
                    return this.parseIntoCollection(this.cfg.getSetFactory(), Token.END_MAP_OR_SET);
                }
                case BEGIN_MAP: {
                    this.nextToken();
                    return this.parseIntoMap(this.cfg.getMapFactory());
                }
                case DISCARD: {
                    this.nextToken();
                    this.discardValue();
                    return this.nextValue();
                }
                case END_LIST: 
                case END_MAP_OR_SET: 
                case END_VECTOR: {
                    throw new EdnException();
                }
                case END_OF_INPUT: {
                    return END_OF_INPUT;
                }
                case NIL: {
                    this.nextToken();
                    return null;
                }
            }
            throw new EdnException();
        }
        if (this.curr instanceof Tag) {
            Tag t = (Tag)this.curr;
            this.nextToken();
            return this.nextValue(t);
        }
        Object value = this.curr;
        this.nextToken();
        return value;
    }

    private Object nextToken() throws IOException {
        try {
            this.curr = this.scanner.nextToken();
            return this.curr;
        }
        catch (IOException e) {
            this.curr = Token.END_OF_INPUT;
            try {
                this.scanner.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private Object nextValue(Tag t) throws IOException {
        Object v = this.nextValue();
        if (this.discard == 0) {
            TagHandler x = this.cfg.getTagHandler(t);
            if (x != null) {
                return x.transform(t, v);
            }
            return TaggedValue.newTaggedValue(t, v);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardValue() throws IOException {
        try {
            ++this.discard;
            this.nextValue();
        }
        finally {
            --this.discard;
        }
    }

    private Object parseIntoMap(CollectionBuilder.Factory f) throws IOException {
        CollectionBuilder b;
        CollectionBuilder collectionBuilder = b = this.discard == 0 ? f.builder() : null;
        while (this.curr != Token.END_MAP_OR_SET) {
            Object o = this.nextValue();
            if (o == END_OF_INPUT) {
                throw new EdnException("Expected '}', but found end of input.\n" + String.valueOf(b.build()));
            }
            if (this.discard != 0) continue;
            b.add(o);
        }
        this.nextToken();
        return this.discard == 0 ? b.build() : null;
    }

    private Object parseIntoCollection(CollectionBuilder.Factory f, Token end) throws IOException {
        CollectionBuilder b;
        CollectionBuilder collectionBuilder = b = this.discard == 0 ? f.builder() : null;
        while (this.curr != end) {
            Object value = this.nextValue();
            if (value == END_OF_INPUT) {
                throw new EdnException();
            }
            if (this.discard != 0) continue;
            b.add(value);
        }
        this.nextToken();
        return this.discard == 0 ? b.build() : null;
    }
}

