/*
 * Decompiled with CFR 0.152.
 */
package bpsm.edn;

import bpsm.edn.EdnException;
import bpsm.edn.Named;
import bpsm.edn.util.CharClassify;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Symbol
implements Named,
Comparable<Symbol> {
    final String prefix;
    final String name;

    @Override
    public final String getPrefix() {
        return this.prefix;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    private Symbol(String prefix, String name) {
        this.prefix = prefix;
        this.name = name;
    }

    public static Symbol newSymbol(String prefix, String name) {
        Symbol.checkArguments(prefix, name);
        return new Symbol(prefix, name);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClass().getName().hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Symbol other = (Symbol)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }

    public String toString() {
        if (this.prefix == null) {
            return this.name;
        }
        return this.prefix + "/" + this.name;
    }

    private static void checkArguments(String prefix, String name) {
        if (name == null) {
            throw new EdnException("name must not be null.");
        }
        Symbol.checkName("name", name);
        if (prefix != null) {
            Symbol.checkName("prefix", prefix);
        }
    }

    private static void checkName(String label, String ident) {
        if (ident.length() == 0) {
            throw new EdnException("The " + label + " '" + ident + "' must not be empty.");
        }
        char first = ident.charAt(0);
        if (CharClassify.isDigit(first)) {
            throw new EdnException("The " + label + " '" + ident + "' must not begin with a digit.");
        }
        if (!CharClassify.symbolStart(first)) {
            throw new EdnException("The " + label + " '" + ident + "' begins with a forbidden character.");
        }
        if ((first == '.' || first == '-') && ident.length() > 1 && CharClassify.isDigit(ident.charAt(1))) {
            throw new EdnException("The " + label + " '" + ident + "' begins with a '-' or '.' followed by digit, which is forbidden.");
        }
        int n = ident.length();
        for (int i = 1; i < n; ++i) {
            if (CharClassify.symbolConstituent(ident.charAt(i))) continue;
            throw new EdnException("The " + label + " '" + ident + "' contains the illegal character '" + ident.charAt(i) + "' at offset " + i + ".");
        }
    }

    @Override
    public int compareTo(Symbol right) {
        int cmp = Symbol.nullToEmpty(this.prefix).compareTo(Symbol.nullToEmpty(right.prefix));
        if (cmp != 0) {
            return cmp;
        }
        return this.name.compareTo(right.name);
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }
}

