/*
 * Decompiled with CFR 0.152.
 */
package clojure.core.matrix.random;

import clojure.lang.ASeq;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Obj;
import java.util.Random;

public class RandomSeq
extends ASeq {
    private static final int INITIAL_CHUNK_SIZE = 20;
    private static final int MAX_CHUNK_SIZE = 160;
    final double[] data;
    Object rand;

    private RandomSeq(double[] data, Random random) {
        this.data = data;
        this.rand = random;
    }

    public RandomSeq(Random random) {
        this(RandomSeq.produce(random, 20), random);
    }

    public static double[] produce(Random random, int count) {
        double[] data = new double[count];
        for (int i = 0; i < count; ++i) {
            data[i] = random.nextDouble();
        }
        return data;
    }

    public int count() {
        throw new UnsupportedOperationException("RandomSeq has infinite elements");
    }

    public IPersistentCollection empty() {
        return null;
    }

    public Object first() {
        return this.data[0];
    }

    private synchronized RandomSeq nextChunk() {
        if (this.rand instanceof RandomSeq) {
            return (RandomSeq)((Object)this.rand);
        }
        Random random = (Random)this.rand;
        RandomSeq result = new RandomSeq(RandomSeq.produce(random, Math.min(160, this.data.length * 2)), random);
        this.rand = result;
        return result;
    }

    public ISeq next() {
        return new Cursor(1);
    }

    public Obj withMeta(IPersistentMap meta) {
        throw new UnsupportedOperationException("RandomSeq does not support metadata");
    }

    private class Cursor
    extends ASeq {
        private final int pos;
        private final double[] data;

        private Cursor(double[] data, int pos) {
            this.pos = pos;
            this.data = data;
        }

        public Cursor(int pos) {
            this(randomSeq.data, pos);
        }

        public int count() {
            throw new UnsupportedOperationException("RandomSeq has infinite elements");
        }

        public IPersistentCollection empty() {
            return null;
        }

        public Object first() {
            return this.data[this.pos];
        }

        public ISeq next() {
            int npos = this.pos + 1;
            if (npos < this.data.length) {
                return new Cursor(npos);
            }
            return RandomSeq.this.nextChunk();
        }

        public Obj withMeta(IPersistentMap meta) {
            throw new UnsupportedOperationException("RandomSeq does not support metadata");
        }
    }
}

