/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.Utils;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSRecordType2;
import org.opendatafoundation.data.spss.SPSSRecordType3;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariableCategory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SPSSVariable {
    SPSSFile file;
    public SPSSRecordType2 variableRecord;
    public SPSSRecordType3 valueLabelRecord;
    VariableType type;
    int variableNumber = 0;
    String variableName = "";
    String variableShortName = "";
    int measure = -1;
    int displayWidth = -1;
    int alignment = -1;
    public Map<String, SPSSVariableCategory> categoryMap = new LinkedHashMap<String, SPSSVariableCategory>();

    public SPSSVariable(SPSSFile file) {
        this.file = file;
    }

    public abstract SPSSVariableCategory addCategory(byte[] var1, String var2) throws SPSSFileException;

    public String getAlignmentLabel() {
        String label = "";
        switch (this.alignment) {
            case 0: {
                label = "Left";
                break;
            }
            case 1: {
                label = "Center";
                break;
            }
            case 2: {
                label = "Right";
            }
        }
        return label;
    }

    public abstract SPSSVariableCategory getCategory(byte[] var1) throws SPSSFileException;

    public abstract int getNumberOfObservations();

    public Element getDDI2(Document doc, int offset) throws SPSSFileException {
        return this.getDDI2(doc, new FileFormatInfo(), offset);
    }

    public Element getDDI2(Document doc, FileFormatInfo dataFormat, int offset) throws SPSSFileException {
        Element var = doc.createElementNS("http://www.icpsr.umich.edu/DDI", "var");
        if (this.getDecimals() > 0) {
            var.setAttribute("dcml", "" + this.getDecimals());
        }
        if (this.type == VariableType.NUMERIC) {
            switch (this.measure) {
                case 1: 
                case 2: {
                    var.setAttribute("intrvl", "discrete");
                    break;
                }
                case 3: {
                    var.setAttribute("intrvl", "contin");
                }
            }
        }
        Element elem = (Element)var.appendChild(doc.createElementNS("http://www.icpsr.umich.edu/DDI", "location"));
        elem.setAttribute("width", "" + this.getLength(dataFormat));
        elem.setAttribute("StartPos", "" + offset);
        elem.setAttribute("EndPos", "" + (offset + this.getLength(dataFormat)));
        var.setAttribute("name", this.getName());
        elem = (Element)var.appendChild(doc.createElementNS("http://www.icpsr.umich.edu/DDI", "labl"));
        elem.setTextContent(this.getLabel());
        if (!this.categoryMap.isEmpty()) {
            for (String key : this.categoryMap.keySet()) {
                SPSSVariableCategory cat = this.categoryMap.get(key);
                Element catgry = (Element)var.appendChild(doc.createElementNS("http://www.icpsr.umich.edu/DDI", "catgry"));
                if (cat.isMissing) {
                    catgry.setAttribute("missing", "Y");
                }
                elem = (Element)catgry.appendChild(doc.createElementNS("http://www.icpsr.umich.edu/DDI", "catValu"));
                elem.setTextContent(cat.strValue);
                elem = (Element)catgry.appendChild(doc.createElementNS("http://www.icpsr.umich.edu/DDI", "labl"));
                elem.setTextContent(cat.label);
            }
        }
        elem = (Element)var.appendChild(doc.createElementNS("http://www.icpsr.umich.edu/DDI", "varFormat"));
        if (this.type == VariableType.NUMERIC) {
            elem.setAttribute("type", "numeric");
        } else {
            elem.setAttribute("type", "character");
        }
        elem.setAttribute("schema", "SPSS");
        elem.setAttribute("formatname", this.getSPSSFormat());
        return var;
    }

    public String getDDI3DefaultCategorySchemeID() {
        return this.file.getUniqueID() + "_" + this.file.categorySchemeIDSuffix + "_V" + this.variableNumber;
    }

    public String getDDI3DefaultCodeSchemeID() {
        return this.file.getUniqueID() + "_" + this.file.codeSchemeIDSuffix + "_V" + this.variableNumber;
    }

    public Element getDDI3CategoryScheme(Document doc) {
        return this.getDDI3CategoryScheme(doc, null);
    }

    private Element getDDI3CategoryScheme(Document doc, String categorySchemeID) {
        Element scheme = null;
        if (!this.categoryMap.isEmpty()) {
            scheme = doc.createElementNS("ddi:logicalproduct:3_0", "CategoryScheme");
            if (categorySchemeID == null) {
                categorySchemeID = this.getDDI3DefaultCategorySchemeID();
            }
            Utils.setDDIMaintainableId(scheme, categorySchemeID);
            int categoryNumber = 0;
            Iterator<String> catIterator = this.categoryMap.keySet().iterator();
            boolean missingCreated = false;
            while (catIterator.hasNext()) {
                Element category;
                String key = catIterator.next();
                SPSSVariableCategory cat = this.categoryMap.get(key);
                if (cat.isMissing && cat.label == "") {
                    if (missingCreated) continue;
                    category = (Element)scheme.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "Category"));
                    Utils.setDDIVersionableId(category, "MISSING");
                    category.setAttribute("missing", "true");
                    missingCreated = true;
                    continue;
                }
                category = (Element)scheme.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "Category"));
                Utils.setDDIVersionableId(category, this.file.variableCategoryPrefix + "_" + ++categoryNumber);
                if (cat.isMissing) {
                    category.setAttribute("missing", "true");
                }
                Element elem = (Element)category.appendChild(doc.createElementNS("ddi:reusable:3_0", "Label"));
                elem.setTextContent(cat.label);
            }
        }
        return scheme;
    }

    public Element getDDI3CodeScheme(Document doc) throws DOMException, SPSSFileException {
        return this.getDDI3CodeScheme(doc, null, null);
    }

    private Element getDDI3CodeScheme(Document doc, String categorySchemeID, String codeSchemeID) throws DOMException, SPSSFileException {
        Element scheme = null;
        if (!this.categoryMap.isEmpty()) {
            scheme = doc.createElementNS("ddi:logicalproduct:3_0", "CodeScheme");
            if (categorySchemeID == null) {
                categorySchemeID = this.getDDI3DefaultCategorySchemeID();
            }
            if (codeSchemeID == null) {
                codeSchemeID = this.getDDI3DefaultCodeSchemeID();
            }
            Utils.setDDIMaintainableId(scheme, codeSchemeID);
            Element categorySchemeReference = (Element)scheme.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "CategorySchemeReference"));
            Element elem = (Element)categorySchemeReference.appendChild(doc.createElementNS("ddi:reusable:3_0", "ID"));
            elem.setTextContent(categorySchemeID);
            Iterator<String> catIterator = this.categoryMap.keySet().iterator();
            int categoryNumber = 0;
            while (catIterator.hasNext()) {
                String key = catIterator.next();
                SPSSVariableCategory cat = this.categoryMap.get(key);
                Element code = (Element)scheme.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "Code"));
                Element categoryReference = (Element)code.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "CategoryReference"));
                elem = (Element)categoryReference.appendChild(doc.createElementNS("ddi:reusable:3_0", "ID"));
                if (cat.isMissing && cat.label == "") {
                    elem.setTextContent("MISSING");
                } else {
                    elem.setTextContent(this.file.variableCategoryPrefix + "_" + ++categoryNumber);
                }
                elem = (Element)code.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "Value"));
                elem.setTextContent(cat.strValue);
            }
        }
        return scheme;
    }

    public Element getDDI3DataItem(Document doc, FileFormatInfo dataFormat, int offset) throws DOMException, SPSSFileException {
        Element dataItem = doc.createElementNS("ddi:physicaldataproduct:3_0", "DataItem");
        Element varReference = (Element)dataItem.appendChild(doc.createElementNS("ddi:physicaldataproduct:3_0", "VariableReference"));
        Element elem = (Element)varReference.appendChild(doc.createElementNS("ddi:reusable:3_0", "ID"));
        elem.setTextContent(this.file.variableIDPrefix + this.variableNumber);
        Element physicalLocation = (Element)dataItem.appendChild(doc.createElementNS("ddi:physicaldataproduct:3_0", "PhysicalLocation"));
        elem = (Element)physicalLocation.appendChild(doc.createElementNS("ddi:physicaldataproduct:3_0", "StorageFormat"));
        elem.setTextContent(this.getSPSSFormat());
        elem = (Element)physicalLocation.appendChild(doc.createElementNS("ddi:physicaldataproduct:3_0", "StartPosition"));
        elem.setTextContent("" + offset);
        elem = (Element)physicalLocation.appendChild(doc.createElementNS("ddi:physicaldataproduct:3_0", "Width"));
        elem.setTextContent("" + this.getLength(dataFormat));
        if (this.getDecimals() > 0) {
            elem = (Element)physicalLocation.appendChild(doc.createElementNS("ddi:physicaldataproduct:3_0", "DecimalPositions"));
            elem.setTextContent("" + this.getDecimals());
        }
        return dataItem;
    }

    public Element getDDI3ProprietaryDataItem(Document doc) throws DOMException, SPSSFileException {
        Element dataItem = doc.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "DataItem");
        Element varReference = (Element)dataItem.appendChild(doc.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "VariableReference"));
        Element elem = (Element)varReference.appendChild(doc.createElementNS("ddi:reusable:3_0", "ID"));
        elem.setTextContent(this.file.variableIDPrefix + this.variableNumber);
        elem = (Element)dataItem.appendChild(doc.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "ProprietaryDataType"));
        elem.setTextContent(this.variableRecord.variableTypeCode == 0 ? "numeric" : "string");
        elem = (Element)dataItem.appendChild(doc.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "ProprietaryOutputFormat"));
        elem.setTextContent(this.getSPSSFormat());
        Element proprietaryInfo = (Element)dataItem.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryInfo"));
        elem = (Element)proprietaryInfo.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
        elem.setAttribute("name", "Width");
        elem.setTextContent("" + this.variableRecord.writeFormatWidth);
        elem = (Element)proprietaryInfo.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
        elem.setAttribute("name", "Decimals");
        elem.setTextContent("" + this.getDecimals());
        if (this.variableRecord.missingValueFormatCode != 0) {
            elem = (Element)proprietaryInfo.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            elem.setAttribute("name", "MissingFormatCode");
            elem.setTextContent("" + this.variableRecord.missingValueFormatCode);
            for (int i = 0; i < Math.abs(this.variableRecord.missingValueFormatCode); ++i) {
                elem = (Element)proprietaryInfo.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
                elem.setAttribute("name", "MissingValue" + i);
                if (this.variableRecord.variableTypeCode == 0) {
                    elem.setTextContent("" + SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[i]));
                    continue;
                }
                String tc = this.file.charset == null ? SPSSUtils.byte8ToString(this.variableRecord.missingValue[i]) : SPSSUtils.byte8ToString(this.variableRecord.missingValue[i], this.file.charset);
                elem.setTextContent(tc);
            }
        }
        if (this.displayWidth != -1) {
            elem = (Element)proprietaryInfo.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            elem.setAttribute("name", "DisplayWidth");
            elem.setTextContent("" + this.displayWidth);
        }
        if (this.alignment != -1) {
            elem = (Element)proprietaryInfo.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            elem.setAttribute("name", "Alignment");
            elem.setTextContent("" + this.getAlignmentLabel());
        }
        if (this.measure != -1) {
            elem = (Element)proprietaryInfo.appendChild(doc.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            elem.setAttribute("name", "Measure");
            elem.setTextContent("" + this.getMeasureLabel());
        }
        return dataItem;
    }

    public Element getDDI3Variable(Document doc) {
        return this.getDDI3Variable(doc, null);
    }

    private Element getDDI3Variable(Document doc, String codeSchemeReferenceID) {
        Element var = null;
        var = doc.createElementNS("ddi:logicalproduct:3_0", "Variable");
        Utils.setDDIVersionableId(var, this.file.variableIDPrefix + this.variableNumber);
        Element elem = (Element)var.appendChild(doc.createElementNS("ddi:reusable:3_0", "Name"));
        elem.setTextContent(this.getName());
        elem = (Element)var.appendChild(doc.createElementNS("ddi:reusable:3_0", "Label"));
        elem.setAttribute("type", "label");
        elem.setAttribute("maxLength", "120");
        elem.setTextContent(this.getLabel());
        elem = (Element)var.appendChild(doc.createElementNS("ddi:reusable:3_0", "Label"));
        elem.setAttribute("type", "name");
        elem.setAttribute("maxLength", "8");
        elem.setTextContent(this.getShortName());
        if (this.hasValueLabels() || this.getDDI3RepresentationType() != null) {
            Element representation = (Element)var.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "Representation"));
            if (this.variableRecord.writeFormatType == 4) {
                representation.setAttribute("measurementUnit", "$");
            }
            if (this.hasValueLabels()) {
                Element codeRepresentation = (Element)representation.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "CodeRepresentation"));
                Element codeSchemeReference = (Element)codeRepresentation.appendChild(doc.createElementNS("ddi:reusable:3_0", "CodeSchemeReference"));
                elem = (Element)codeSchemeReference.appendChild(doc.createElementNS("ddi:reusable:3_0", "ID"));
                if (codeSchemeReferenceID == null) {
                    codeSchemeReferenceID = this.getDDI3DefaultCodeSchemeID();
                }
                elem.setTextContent(codeSchemeReferenceID);
            } else {
                String dataType = this.getDDI3DataType();
                if (this.getDDI3RepresentationType() == DDI3RepresentationType.NUMERIC) {
                    elem = (Element)representation.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "NumericRepresentation"));
                    if (dataType != null) {
                        elem.setAttribute("type", dataType);
                    }
                    elem.setAttribute("decimalPositions", "" + this.getDecimals());
                }
                if (this.getDDI3RepresentationType() == DDI3RepresentationType.DATETIME) {
                    elem = (Element)representation.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "DateTimeRepresentation"));
                    if (dataType != null) {
                        elem.setAttribute("type", dataType);
                    }
                    elem.setAttribute("format", this.getSPSSFormat());
                }
                if (this.getDDI3RepresentationType() == DDI3RepresentationType.TEXT) {
                    elem = (Element)representation.appendChild(doc.createElementNS("ddi:logicalproduct:3_0", "TextRepresentation"));
                    elem.setAttribute("maxLength", "" + this.getLength());
                }
            }
        }
        return var;
    }

    public DDI3RepresentationType getDDI3RepresentationType() {
        DDI3RepresentationType type = null;
        switch (this.variableRecord.writeFormatType) {
            case 0: 
            case 1: 
            case 2: 
            case 26: 
            case 27: {
                type = DDI3RepresentationType.TEXT;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                type = DDI3RepresentationType.NUMERIC;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: {
                type = DDI3RepresentationType.DATETIME;
            }
        }
        return type;
    }

    public String getDDI3DataType() {
        String typeStr = null;
        switch (this.variableRecord.writeFormatType) {
            case 0: 
            case 1: 
            case 2: 
            case 26: 
            case 27: {
                typeStr = "String";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                if (this.getDecimals() > 0) {
                    typeStr = "Decimal";
                    break;
                }
                typeStr = "BigInteger";
                break;
            }
            case 17: {
                typeStr = "Double";
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: {
                typeStr = "Date";
                break;
            }
            case 21: {
                typeStr = "Time";
                break;
            }
            case 22: 
            case 25: {
                typeStr = "DateTime";
                break;
            }
            default: {
                typeStr = null;
            }
        }
        return typeStr;
    }

    public int getDecimals() {
        return this.variableRecord.writeFormatDecimals;
    }

    public String getLabel() {
        return this.variableRecord.label;
    }

    public int getLength() {
        return this.getLength(new FileFormatInfo(FileFormatInfo.Format.SPSS));
    }

    public int getLength(FileFormatInfo format) {
        return this.variableRecord.writeFormatWidth;
    }

    public String getMeasureLabel() {
        String label = "";
        switch (this.measure) {
            case 1: {
                label = "Nominal";
                break;
            }
            case 2: {
                label = "Ordinal";
                break;
            }
            case 3: {
                label = "Scale";
            }
        }
        return label;
    }

    public String getName() {
        return this.variableName;
    }

    public int getNumber() {
        return this.variableNumber;
    }

    public abstract String getSPSSFormat();

    public String getShortName() {
        return this.variableShortName;
    }

    public abstract String getValueAsString(int var1, FileFormatInfo var2) throws SPSSFileException;

    public boolean hasValueLabels() {
        return !this.categoryMap.isEmpty();
    }

    public boolean isDate() {
        return this.valueLabelRecord != null;
    }

    public boolean isMissingValueCode(double value) {
        boolean rc = false;
        if (this.variableRecord.missingValueFormatCode > 0) {
            for (int i = 0; i < this.variableRecord.missingValueFormatCode; ++i) {
                if (value != SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[i])) continue;
                rc = true;
                break;
            }
        } else if (this.variableRecord.missingValueFormatCode <= -2) {
            if (value >= SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[0]) && value <= SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[1])) {
                rc = true;
            } else if (this.variableRecord.missingValueFormatCode == -3 && value == SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[2])) {
                rc = true;
            }
        }
        return rc;
    }

    public boolean isMissingValueCode(String str) {
        boolean rc = false;
        if (this.variableRecord.missingValueFormatCode > 0) {
            for (int i = 0; i < this.variableRecord.missingValueFormatCode; ++i) {
                String strcmp = this.file.charset == null ? SPSSUtils.byte8ToString(this.variableRecord.missingValue[i]) : SPSSUtils.byte8ToString(this.variableRecord.missingValue[i], this.file.charset);
                if (str.compareToIgnoreCase(strcmp) != 0) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    static enum DDI3RepresentationType {
        TEXT,
        NUMERIC,
        DATETIME;

    }

    static enum VariableType {
        NUMERIC,
        STRING;

    }
}

