/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.GregorianCalendar;

public class SPSSUtils {
    public static double byte8ToDouble(byte[] buffer) {
        long lvalue = ((long)buffer[7] << 56) + ((long)(buffer[6] & 0xFF) << 48) + ((long)(buffer[5] & 0xFF) << 40) + ((long)(buffer[4] & 0xFF) << 32) + ((long)(buffer[3] & 0xFF) << 24) + ((long)(buffer[2] & 0xFF) << 16) + ((long)(buffer[1] & 0xFF) << 8) + (long)(buffer[0] & 0xFF);
        return Double.longBitsToDouble(lvalue);
    }

    public static String byte8ToString(byte[] buffer) {
        String str = new String(buffer).replaceAll("\\s+$", "");
        return str;
    }

    public static String byte8ToString(byte[] buffer, Charset charset) {
        String str = new String(buffer, charset).replaceAll("\\s+$", "");
        return str;
    }

    public static int byte4ToInt(byte[] buffer) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n |= (buffer[i] & 0xFF) << i * 8;
        }
        return n;
    }

    public static GregorianCalendar numericToCalendar(double value) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(1970, 0, 1, 0, 0, 0);
        int daysOffset = (int)((value -= 1.22193792E10) / 86400.0);
        int hoursOffset = (int)((value -= (double)daysOffset * 86400.0) / 3600.0);
        int minutesOffset = (int)((value -= (double)hoursOffset * 3600.0) / 60.0);
        int secondsOffset = (int)(value -= (double)minutesOffset * 60.0);
        int hundredsOffset = (int)(value - (double)secondsOffset) * 100;
        calendar.add(6, daysOffset);
        calendar.add(11, hoursOffset);
        calendar.add(12, minutesOffset);
        calendar.add(13, secondsOffset);
        calendar.add(14, hundredsOffset * 10);
        return calendar;
    }

    public static Date numericToDate(double value) {
        double secondsSince1970 = value - 1.22193792E10;
        return new Date((long)(secondsSince1970 * 1000.0));
    }
}

