/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype5
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    String variableSets;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 5: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        if (this.recordSubtypeCode != 5) {
            throw new SPSSFileException("Error reading record type 7 subtype 5: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 5.");
        }
        this.dataElementLength = is.readSPSSInt();
        if (this.dataElementLength != 1) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad data element length [" + this.dataElementLength + "]. Expecting 1.");
        }
        this.numberOfDataElements = is.readSPSSInt();
        this.variableSets = is.readSPSSString(this.numberOfDataElements);
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 7 SUBTYPE 5 - VARIABLE SETS INFORMATION";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nRecord Subtype  : " + this.recordSubtypeCode;
        str = str + "\nData elements   : " + this.numberOfDataElements;
        str = str + "\nElement length  : " + this.dataElementLength;
        str = str + "\nVariable sets   :\n " + this.variableSets;
        return str;
    }
}

