/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype21
extends SPSSAbstractRecordType {
    private static final int RECORD_TYPE = 7;
    private static final int SUB_RECORD_TYPE = 21;
    private static final int DATA_ELEMENT_LENGTH = 1;
    private int recordTypeCode;
    private int recordSubtypeCode;
    private int dataElementLength;
    private int numberOfDataElements;
    public final Collection<Variable> variables = new ArrayList<Variable>();

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type  7 subtype 21: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        if (this.recordSubtypeCode != 21) {
            throw new SPSSFileException("Error reading record type7subtype 21: bad sub-record type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 21.");
        }
        this.dataElementLength = is.readSPSSInt();
        if (this.dataElementLength != 1) {
            throw new SPSSFileException("Error reading record type7subtype 21: bad data element length [" + this.dataElementLength + "]. Expecting 1.");
        }
        this.numberOfDataElements = is.readSPSSInt();
        long filePointer = is.getFilePointer();
        long bytesRead = 0L;
        while (bytesRead < (long)this.numberOfDataElements) {
            Variable variable = new Variable();
            variable.read(is);
            this.variables.add(variable);
            bytesRead = is.getFilePointer() - filePointer;
        }
    }

    public Collection<Variable> getVariables() {
        return this.variables;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder().append("\nRECORD TYPE 7 SUBTYPE 21 - LONG VARIABLE LABELS").append("\nLocation              : ").append(this.fileLocation).append("\nRecord Type           : ").append(this.recordTypeCode).append("\nRecord Subtype        : ").append(this.recordSubtypeCode).append("\nData elements         : ").append(this.numberOfDataElements).append("\nElement length        : ").append(this.dataElementLength);
        for (Variable variable : this.variables) {
            str.append(variable.toString());
        }
        return str.toString();
    }

    public static class Label {
        private int valueLength;
        private String value;
        private int labelLength;
        private String label;

        public void read(SPSSFile is) throws IOException {
            this.valueLength = is.readSPSSInt();
            this.value = is.readSPSSString(this.valueLength);
            this.labelLength = is.readSPSSInt();
            this.label = is.readSPSSString(this.labelLength);
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "\nLabels" + "\n- Label length  : " + this.labelLength + "\n- Label         : " + this.label + "\n- Value length  : " + this.valueLength + "\n- Value         : " + this.value;
        }
    }

    public static class Variable {
        private int variableNameLength;
        private String name;
        private int nameWidth;
        private int numberOfLabels;
        private final Collection<Label> labels = new ArrayList<Label>();

        public void read(SPSSFile is) throws IOException {
            this.variableNameLength = is.readSPSSInt();
            this.name = is.readSPSSString(this.variableNameLength);
            this.nameWidth = is.readSPSSInt();
            this.numberOfLabels = is.readSPSSInt();
            for (int i = 0; i < this.numberOfLabels; ++i) {
                Label longStringLabel = new Label();
                longStringLabel.read(is);
                this.labels.add(longStringLabel);
            }
        }

        public Collection<Label> getLabels() {
            return this.labels;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder str = new StringBuilder().append("\nVariable").append("\n- Variable name length  : ").append(this.variableNameLength).append("\n- Variable name         : ").append(this.name).append("\n- Variable width        : ").append(this.nameWidth).append("\n- Number of labels      : ").append(this.numberOfLabels);
            for (Label label : this.labels) {
                str.append(label.toString());
            }
            return str.toString();
        }
    }
}

