/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype14
extends SPSSAbstractRecordType {
    private static final int RECORD_TYPE = 7;
    private static final int SUB_RECORD_TYPE = 14;
    private int recordTypeCode;
    private int recordSubtypeCode;
    private int size;
    private int count;
    private Map<String, Integer> stringLengths = new LinkedHashMap<String, Integer>();

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type  7 subtype 14: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        if (this.recordSubtypeCode != 14) {
            throw new SPSSFileException("Error reading record type7subtype 14: bad sub-record type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 21.");
        }
        this.size = is.readSPSSInt();
        this.count = is.readSPSSInt();
        String rawMap = is.readSPSSString(this.count);
        StringTokenizer st1 = new StringTokenizer(rawMap, "\t");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            if (st2.countTokens() < 2) continue;
            this.stringLengths.put(st2.nextToken(), Integer.parseInt(st2.nextToken().replaceAll("\\u0000", "")));
        }
    }

    public Set<Map.Entry<String, Integer>> entries() {
        return this.stringLengths.entrySet();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder().append("\nRECORD TYPE 7 SUBTYPE 14 - LONG VARIABLE LABELS").append("\nLocation              : ").append(this.fileLocation).append("\nRecord Type           : ").append(this.recordTypeCode).append("\nRecord Subtype        : ").append(this.recordSubtypeCode).append("\nSize                  : ").append(this.size).append("\nCount                 : ").append(this.count).append("\nString lengths:       ");
        for (Map.Entry<String, Integer> entry : this.stringLengths.entrySet()) {
            str.append("\t").append(entry);
        }
        return str.toString();
    }
}

