/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype13
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    Map<String, String> nameMap;
    String longNamesStr;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        if (this.recordSubtypeCode != 13) {
            throw new SPSSFileException("Error reading record type 7 subtype 13: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 13.");
        }
        this.dataElementLength = is.readSPSSInt();
        if (this.dataElementLength != 1) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad data element length [" + this.dataElementLength + "]. Expecting 1.");
        }
        this.numberOfDataElements = is.readSPSSInt();
        this.longNamesStr = is.readSPSSString(this.numberOfDataElements);
        this.nameMap = new LinkedHashMap<String, String>();
        StringTokenizer st1 = new StringTokenizer(this.longNamesStr, "\t");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            if (st2.countTokens() < 2) continue;
            this.nameMap.put(st2.nextToken(), st2.nextToken());
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 7 SUBTYPE 13 - LONG VARIABLE NAMES";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nRecord Subtype  : " + this.recordSubtypeCode;
        str = str + "\nData elements   : " + this.numberOfDataElements;
        str = str + "\nElement length  : " + this.dataElementLength;
        str = str + "\nLong Names      : " + this.longNamesStr;
        for (Map.Entry<String, String> entry : this.nameMap.entrySet()) {
            str = str + "\n" + entry.getKey() + " = " + entry.getValue();
        }
        return str;
    }

    public class VariableDisplayParams {
        int measure;
        int width;
        int alignment;
    }
}

