/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype11
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    List<VariableDisplayParams> variableDisplayParams;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        if (this.recordSubtypeCode != 11) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 11.");
        }
        this.dataElementLength = is.readSPSSInt();
        if (this.dataElementLength != 4) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: bad data element length [" + this.dataElementLength + "]. Expecting 4.");
        }
        this.numberOfDataElements = is.readSPSSInt();
        int n_variables = this.numberOfDataElements / 3;
        if (this.numberOfDataElements % 3 != 0) {
            throw new SPSSFileException("Error reading record type 7 subtype 11: number of data elements [" + this.dataElementLength + "] is not a multiple of 3.");
        }
        this.variableDisplayParams = new ArrayList<VariableDisplayParams>();
        for (int i = 0; i < n_variables; ++i) {
            VariableDisplayParams params = new VariableDisplayParams();
            params.measure = is.readSPSSInt();
            params.width = is.readSPSSInt();
            params.alignment = is.readSPSSInt();
            this.variableDisplayParams.add(params);
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 7 SUBTYPE 11 - VARIABLE DISPLAY PARAMETERS";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nRecord Subtype  : " + this.recordSubtypeCode;
        str = str + "\nData elements   : " + this.numberOfDataElements;
        str = str + "\nElement length  : " + this.dataElementLength;
        int var_index = 0;
        for (VariableDisplayParams params : this.variableDisplayParams) {
            str = str + "\nDisplay params  : Var " + ++var_index + " Measure=" + params.measure + " Width=" + params.width + " Alignment=" + params.alignment;
        }
        return str;
    }

    public class VariableDisplayParams {
        int measure;
        int width;
        int alignment;
    }
}

