/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading variableRecord: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        this.dataElementLength = is.readSPSSInt();
        this.numberOfDataElements = is.readSPSSInt();
        this.dataElement = new ArrayList<byte[]>();
        byte[] data = new byte[this.dataElementLength];
        for (int i = 0; i < this.numberOfDataElements; ++i) {
            is.read(data);
            this.dataElement.add(data);
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 7 - GENERIC";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nRecord Subtype  : " + this.recordSubtypeCode;
        str = str + "\nData elements   : " + this.numberOfDataElements;
        str = str + "\nElement length  : " + this.dataElementLength;
        return str;
    }
}

