/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType4
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int numberOfVariables;
    int[] variableIndex;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 4) {
            throw new SPSSFileException("Error reading Variable Index record: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 4.");
        }
        this.numberOfVariables = is.readSPSSInt();
        this.variableIndex = new int[this.numberOfVariables];
        for (int i = 0; i < this.numberOfVariables; ++i) {
            this.variableIndex[i] = is.readSPSSInt();
        }
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 4 - VARIABLE INDEX RECORD FOR VALUE LABELS";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nNumber of vars  : " + this.numberOfVariables;
        str = str + "\nVar indexes     : ";
        for (int i = 0; i < this.numberOfVariables; ++i) {
            str = str + this.variableIndex[i];
        }
        return str;
    }
}

