/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariable;
import org.opendatafoundation.data.spss.SPSSVariableCategory;

public class SPSSNumericVariable
extends SPSSVariable {
    public List<Double> data;
    public double value;
    public double min = Double.MAX_VALUE;
    public double max = Double.MIN_VALUE;
    public double mean = 0.0;
    public double min_wgt = Double.MAX_VALUE;
    public double max_wgt = Double.MIN_VALUE;
    public double mean_wgt = 0.0;

    public SPSSNumericVariable(SPSSFile file) {
        super(file);
        this.data = new ArrayList<Double>();
        this.type = SPSSVariable.VariableType.NUMERIC;
    }

    @Override
    public int getNumberOfObservations() {
        return this.data.size();
    }

    @Override
    public SPSSVariableCategory addCategory(byte[] byteValue, String label) throws SPSSFileException {
        double value = SPSSUtils.byte8ToDouble(byteValue);
        return this.addCategory(value, label);
    }

    public SPSSVariableCategory addCategory(double value, String label) throws SPSSFileException {
        String strValue = this.valueToString(value).trim();
        SPSSVariableCategory cat = (SPSSVariableCategory)this.categoryMap.get(strValue);
        if (cat == null) {
            cat = new SPSSVariableCategory();
            this.categoryMap.put(strValue, cat);
        }
        cat.value = value;
        cat.strValue = strValue;
        cat.label = label;
        return cat;
    }

    @Override
    public SPSSVariableCategory getCategory(byte[] byteValue) throws SPSSFileException {
        double value = SPSSUtils.byte8ToDouble(byteValue);
        return this.getCategory(value);
    }

    public SPSSVariableCategory getCategory(double value) throws SPSSFileException {
        return (SPSSVariableCategory)this.categoryMap.get(this.valueToString(value));
    }

    @Override
    public String getSPSSFormat() {
        String formatStr = "";
        switch (this.variableRecord.writeFormatType) {
            case 3: {
                formatStr = "Comma" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 4: {
                formatStr = "Dollar" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 5: {
                formatStr = "F" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 17: {
                formatStr = "E" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 20: {
                formatStr = "Date" + this.getLength();
                break;
            }
            case 21: {
                formatStr = "Time" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 22: {
                formatStr = "DateTime" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 23: {
                formatStr = "ADate" + this.getLength();
                break;
            }
            case 24: {
                formatStr = "JDate" + this.getLength();
                break;
            }
            case 25: {
                formatStr = "DTime" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 26: {
                formatStr = "Wkday" + this.getLength();
                break;
            }
            case 27: {
                formatStr = "Month" + this.getLength();
                break;
            }
            case 28: {
                formatStr = "Moyr" + this.getLength();
                break;
            }
            case 29: {
                formatStr = "QYr" + this.getLength();
                break;
            }
            case 30: {
                formatStr = "Wkyr" + this.getLength();
                break;
            }
            case 32: {
                formatStr = "Dot" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 33: {
                formatStr = "Cca" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 34: {
                formatStr = "Ccb" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 35: {
                formatStr = "Ccc" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 36: {
                formatStr = "Ccd" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 37: {
                formatStr = "Cce" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 38: {
                formatStr = "EDate" + this.getLength();
                break;
            }
            case 39: {
                formatStr = "SDate" + this.getLength();
                break;
            }
            default: {
                formatStr = "other";
            }
        }
        return formatStr;
    }

    public double getValueAsDouble(int obsNumber) throws SPSSFileException {
        double val;
        if (obsNumber < 0 || obsNumber > this.data.size()) {
            throw new SPSSFileException("Invalid observation number [" + obsNumber + ". Range is 1 to " + this.data.size() + "] or 0.");
        }
        if (obsNumber == 0) {
            val = this.value;
        } else {
            if (obsNumber > 0 && this.data.size() == 0) {
                throw new SPSSFileException("No data available");
            }
            val = this.data.get(obsNumber - 1);
        }
        return val;
    }

    @Override
    public String getValueAsString(int obsNumber, FileFormatInfo dataFormat) throws SPSSFileException {
        double val = this.getValueAsDouble(obsNumber);
        if (obsNumber < 0 || obsNumber > this.data.size()) {
            throw new SPSSFileException("Invalid observation number [" + obsNumber + ". Range is 1 to " + this.data.size() + "] or 0.");
        }
        if (obsNumber == 0) {
            val = this.value;
        } else {
            if (obsNumber > 0 && this.data.size() == 0) {
                throw new SPSSFileException("No data available");
            }
            val = this.data.get(obsNumber - 1);
        }
        String strValue = this.valueToString(val).trim();
        if (strValue.equals(".")) {
            strValue = "";
        }
        if (dataFormat.format == FileFormatInfo.Format.ASCII && dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.CSV && (strValue.contains(",") || strValue.contains("\"") || strValue.contains("\n"))) {
            strValue = "\"" + strValue + "\"";
        }
        return strValue;
    }

    public String valueToString(double value) throws SPSSFileException {
        String strValue;
        String strFormat = "";
        if (new Double(value).isNaN()) {
            strValue = ".";
        } else {
            switch (this.variableRecord.writeFormatType) {
                case 3: {
                    strFormat = strFormat + "%,." + this.getDecimals() + "f";
                    strValue = String.format(Locale.US, strFormat, value);
                    break;
                }
                case 4: {
                    strFormat = strFormat + "$%." + this.getDecimals() + "f";
                    strValue = String.format(Locale.US, strFormat, value);
                    break;
                }
                case 5: {
                    strFormat = strFormat + "%" + this.getLength() + "." + this.getDecimals() + "f";
                    strValue = String.format(Locale.US, strFormat, value);
                    break;
                }
                case 17: {
                    int nDecimals = this.getDecimals();
                    if (nDecimals > 0) {
                        --nDecimals;
                    }
                    strFormat = strFormat + "% " + this.getLength() + "." + nDecimals + "E";
                    strValue = String.format(Locale.US, strFormat, value);
                    break;
                }
                case 20: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = this.getLength() == 11 ? strFormat + "%1$td-%1$tb-%1$tY" : strFormat + "%1$td-%1$tb-%1$ty";
                    strValue = String.format(Locale.US, strFormat, calendar).toUpperCase();
                    break;
                }
                case 21: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = strFormat + "%1$tH:%1$tM";
                    if (this.getLength() >= 8) {
                        strFormat = strFormat + ":%1$tS";
                    }
                    if (this.getLength() == 11) {
                        strFormat = strFormat + ".%2$2d";
                    }
                    strValue = String.format(Locale.US, strFormat, calendar, calendar.get(14) / 10).toUpperCase();
                    break;
                }
                case 22: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = strFormat + "%1$td-%1$tb-%1$tY %1$tH:%1$tM";
                    if (this.getLength() >= 20) {
                        strFormat = strFormat + ":%1$tS";
                    }
                    if (this.getLength() == 23) {
                        strFormat = strFormat + ".%2$2d";
                    }
                    strValue = String.format(Locale.US, strFormat, calendar, calendar.get(14) / 10).toUpperCase();
                    break;
                }
                case 23: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = this.getLength() == 10 ? strFormat + "%1$tm/%1$td/%1$tY" : strFormat + "%1$tm/%1$td/%1$ty";
                    strValue = String.format(Locale.US, strFormat, calendar);
                    break;
                }
                case 24: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = this.getLength() == 7 ? strFormat + "%1$tY%1$tj" : strFormat + "%1$ty%1$tj";
                    strValue = String.format(Locale.US, strFormat, calendar);
                    break;
                }
                case 25: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = strFormat + "%1$tj:%1$tH:%1$tM";
                    if (this.getLength() >= 12) {
                        strFormat = strFormat + ":%1$tS";
                    }
                    if (this.getLength() == 15) {
                        strFormat = strFormat + ".%2$2d";
                    }
                    strValue = String.format(Locale.US, strFormat, calendar, calendar.get(14) / 10);
                    break;
                }
                case 26: {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(7, (int)value);
                    strFormat = this.getLength() == 9 ? strFormat + "%1$tA" : strFormat + "%1$ta";
                    strValue = String.format(Locale.US, strFormat, calendar).toUpperCase();
                    break;
                }
                case 27: {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.set(2, (int)value - 1);
                    strFormat = strFormat + "%1$tb";
                    strValue = String.format(Locale.US, strFormat, calendar).toUpperCase();
                    break;
                }
                case 28: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = this.getLength() == 8 ? strFormat + "%1$tb %1$tY" : strFormat + "%1$tb %1$ty";
                    strValue = String.format(Locale.US, strFormat, calendar).toUpperCase();
                    break;
                }
                case 29: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = calendar.get(2) <= 3 ? strFormat + "1 Q " : (calendar.get(2) <= 6 ? strFormat + "2 Q " : (calendar.get(2) <= 9 ? strFormat + "3 Q " : strFormat + "4 Q"));
                    strFormat = this.getLength() == 8 ? strFormat + "%1$tY" : strFormat + "%1$ty";
                    strValue = String.format(Locale.US, strFormat, calendar);
                    break;
                }
                case 30: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = this.getLength() == 10 ? strFormat + "%1$2d WK %2$tY" : strFormat + "%1$2d WK %2$ty";
                    strValue = String.format(Locale.US, strFormat, calendar.get(3), calendar);
                    break;
                }
                case 32: {
                    strFormat = strFormat + "%,." + this.getDecimals() + "f";
                    strValue = String.format(Locale.GERMANY, strFormat, value);
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    strFormat = strFormat + "%" + this.getLength() + "." + this.getDecimals() + "f";
                    strValue = String.format(Locale.US, strFormat, value);
                    break;
                }
                case 38: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = this.getLength() == 10 ? strFormat + "%1$td.%1$tm.%1$tY" : strFormat + "%1$td.%1$tm.%1$ty";
                    strValue = String.format(Locale.US, strFormat, calendar);
                    break;
                }
                case 39: {
                    GregorianCalendar calendar = SPSSUtils.numericToCalendar(value);
                    strFormat = this.getLength() == 10 ? strFormat + "%1$tY/%1$tm.%1$td" : strFormat + "%1$ty/%1$tm/%1$td";
                    strValue = String.format(Locale.US, strFormat, calendar);
                    break;
                }
                default: {
                    throw new SPSSFileException("Unknown write format type [" + this.variableRecord.writeFormatType + "]");
                }
            }
        }
        return strValue;
    }
}

