/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import java.util.List;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType7Subtype3
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int recordSubtypeCode;
    int dataElementLength;
    int numberOfDataElements;
    int releaseMajor;
    int releaseMinor;
    int releaseSpecial;
    int machineCode;
    int floatRepresentation;
    int compressionScheme;
    int endianness;
    int characterRepresentation;
    List<byte[]> dataElement;

    @Override
    public void read(SPSSFile is) throws IOException, SPSSFileException {
        this.fileLocation = is.getFilePointer();
        this.recordTypeCode = is.readSPSSInt();
        if (this.recordTypeCode != 7) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 7.");
        }
        this.recordSubtypeCode = is.readSPSSInt();
        if (this.recordSubtypeCode != 3) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad subrecord type [" + this.recordSubtypeCode + "]. Expecting Record Subtype 3.");
        }
        this.dataElementLength = is.readSPSSInt();
        if (this.dataElementLength != 4) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad data element length [" + this.dataElementLength + "]. Expecting 4.");
        }
        this.numberOfDataElements = is.readSPSSInt();
        if (this.numberOfDataElements != 8) {
            throw new SPSSFileException("Error reading record type 7 subtype 3: bad number of data elements [" + this.dataElementLength + "]. Expecting 8.");
        }
        this.releaseMajor = is.readSPSSInt();
        this.releaseMinor = is.readSPSSInt();
        this.releaseSpecial = is.readSPSSInt();
        this.machineCode = is.readSPSSInt();
        this.floatRepresentation = is.readSPSSInt();
        this.compressionScheme = is.readSPSSInt();
        this.endianness = is.readSPSSInt();
        this.characterRepresentation = is.readSPSSInt();
    }

    @Override
    public String toString() {
        String str = "";
        str = str + "\nRECORD TYPE 7 SUBTYPE 3 - RELEASE AND MACHINE SPECIFIC INTEGER INFORMATION";
        str = str + "\nLocation        : " + this.fileLocation;
        str = str + "\nRecord Type     : " + this.recordTypeCode;
        str = str + "\nRecord Subtype  : " + this.recordSubtypeCode;
        str = str + "\nData elements   : " + this.numberOfDataElements;
        str = str + "\nElement length  : " + this.dataElementLength;
        str = str + "\nRelease major   : " + this.releaseMajor;
        str = str + "\nRelease minor   : " + this.releaseMinor;
        str = str + "\nRelease special : " + this.releaseSpecial;
        str = str + "\nMachine code    : " + this.machineCode;
        str = str + "\nFloating point  : " + this.floatRepresentation + " [" + this.getFloatRepresentationLabel() + "]";
        str = str + "\nEndianness      : " + this.endianness + " [" + this.getEndiannessLabel() + "]";
        str = str + "\nCharacter set   : " + this.characterRepresentation + " [" + this.getCharacterRepresentationLabel() + "]";
        return str;
    }

    public String getFloatRepresentationLabel() {
        String label = "Unknown";
        switch (this.floatRepresentation) {
            case 1: {
                label = "IEEE";
                break;
            }
            case 2: {
                label = "IBM 370";
                break;
            }
            case 3: {
                label = "DEX VAX E";
            }
        }
        return label;
    }

    public String getEndiannessLabel() {
        String label = "Unknown";
        switch (this.floatRepresentation) {
            case 1: {
                label = "Big endian";
                break;
            }
            case 2: {
                label = "Little endian";
            }
        }
        return label;
    }

    public String getCharacterRepresentationLabel() {
        String label = "Unknown";
        switch (this.characterRepresentation) {
            case 1: {
                label = "EBCDIC";
                break;
            }
            case 2: {
                label = "7-bit ASCII";
                break;
            }
            case 3: {
                label = "8-bit ASCII";
                break;
            }
            case 4: {
                label = "DEC Kanji";
            }
        }
        return label;
    }
}

