/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.Utils;
import org.opendatafoundation.data.spss.SPSSDataRecord;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSNumericVariable;
import org.opendatafoundation.data.spss.SPSSRecordType1;
import org.opendatafoundation.data.spss.SPSSRecordType2;
import org.opendatafoundation.data.spss.SPSSRecordType3;
import org.opendatafoundation.data.spss.SPSSRecordType4;
import org.opendatafoundation.data.spss.SPSSRecordType6;
import org.opendatafoundation.data.spss.SPSSRecordType7;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype11;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype13;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype14;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype21;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype3;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype4;
import org.opendatafoundation.data.spss.SPSSRecordType7Subtype5;
import org.opendatafoundation.data.spss.SPSSStringVariable;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariable;
import org.opendatafoundation.data.spss.SPSSVariableCategory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPSSFile
extends RandomAccessFile {
    public static final int VERSION_MAJOR = 2008;
    public static final int VERSION_MINOR = 1;
    public static final String DDI2_NAMESPACE = "http://www.icpsr.umich.edu/DDI";
    public static final String DDI3_ARCHIVE_NAMESPACE = "ddi:archive:3_0";
    public static final String DDI3_INSTANCE_NAMESPACE = "ddi:instance:3_0";
    public static final String DDI3_LOGICAL_PRODUCT_NAMESPACE = "ddi:logicalproduct:3_0";
    public static final String DDI3_PHYSICAL_PRODUCT_NAMESPACE = "ddi:physicaldataproduct:3_0";
    public static final String DDI3_PHYSICAL_INSTANCE_NAMESPACE = "ddi:physicalinstance:3_0";
    public static final String DDI3_PROPRIETARY_RECORD_NAMESPACE = "ddi:physicaldataproduct/proprietary:3_0_Beta";
    public static final String DDI3_REUSABLE_NAMESPACE = "ddi:reusable:3_0";
    public static final String DDI3_STUDY_UNIT_NAMESPACE = "ddi:studyunit:3_0";
    public String categorySchemeIDSuffix = "CatSch";
    public String codeSchemeIDSuffix = "CodSch";
    public String dataRelationshipID = "DataRel";
    public String grossFileID = "GroFilStr";
    public String grossRecordStructureID = "GroRecStr";
    public String logicalRecordID = "LogRec";
    public String physicalRecordSegmentID = "PhysRecSeg1";
    public String logicalProductIDSuffix = "LogPrd";
    public String physicalDataProductIDSuffix = "PhyPrd";
    public String physicalStructureSchemeSuffix = "PhyStrSch";
    public String physicalStructureID = "PhyStr";
    public String recordLayoutSchemeSuffix = "RecLaySch";
    public String physicalInstanceIDSuffix = "PhyIns";
    public String physicalInstanceFileID = "DataFile";
    public String variableSchemeIDSuffix = "VarSch";
    public String variableCategoryPrefix = "Cat";
    public String variableIDPrefix = "V";
    public Boolean logFlag = true;
    public File logFile;
    Writer logWriter;
    private long start;
    private long elapsed;
    public File file;
    String uniqueID;
    boolean isBigEndian = false;
    byte[] cacheBuffer = new byte[4096];
    long cacheStart = -1L;
    long cachePointer = -1L;
    long cacheEnd = -1L;
    Charset charset = null;
    SPSSRecordType1 infoRecord;
    Map<Integer, SPSSVariable> variableMap;
    Map<String, SPSSVariable> variableShortNameMap;
    SPSSRecordType6 documentationRecord;
    SPSSRecordType7Subtype3 integerInformationRecord;
    SPSSRecordType7Subtype4 floatInformationRecord;
    SPSSRecordType7Subtype5 variableSetsInformationRecord;
    SPSSRecordType7Subtype11 variableDisplayParamsRecord;
    SPSSRecordType7Subtype14 veryLongStringVariableRecord;
    SPSSRecordType7Subtype13 longVariableNamesRecord;
    public boolean isMetadataLoaded = false;
    long dataStartPosition = -1L;
    public boolean isDataLoaded = false;

    public SPSSFile(File file) throws FileNotFoundException {
        super(file, "r");
        this.file = file;
    }

    public SPSSFile(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.file = file;
    }

    public SPSSFile(String name) throws FileNotFoundException {
        super(name, "r");
        this.file = new File(name);
    }

    public SPSSFile(String name, String mode) throws FileNotFoundException {
        super(name, "r");
        this.file = new File(name);
    }

    public SPSSFile(File file, Charset charset) throws FileNotFoundException {
        super(file, "r");
        this.file = file;
        this.charset = charset;
    }

    public SPSSFile(File file, String mode, Charset charset) throws FileNotFoundException {
        super(file, mode);
        this.file = file;
        this.charset = charset;
    }

    public SPSSFile(String name, Charset charset) throws FileNotFoundException {
        super(name, "r");
        this.file = new File(name);
        this.charset = charset;
    }

    public SPSSFile(String name, String mode, Charset charset) throws FileNotFoundException {
        super(name, "r");
        this.file = new File(name);
        this.charset = charset;
    }

    public void dumpData() throws SPSSFileException, IOException {
        this.dumpData(0);
    }

    public void dumpData(int nRecords) throws SPSSFileException, IOException {
        this.dumpData(nRecords, new FileFormatInfo());
    }

    public void dumpData(int nRecords, FileFormatInfo dataFormat) throws SPSSFileException, IOException {
        if (nRecords <= 0 || nRecords > this.getRecordCount()) {
            nRecords = this.getRecordCount();
        }
        this.log(this.getRecordFromDisk(dataFormat, true));
        for (int i = 2; i <= nRecords; ++i) {
            this.log(this.getRecordFromDisk(dataFormat, false));
        }
    }

    public void dumpDDI2() throws SPSSFileException, TransformerException {
        this.log(Utils.DOM2String(this.getDDI2(new FileFormatInfo())));
    }

    public void dumpDDI3() throws SPSSFileException, TransformerException {
        this.log(Utils.DOM2String(this.getDDI3LogicalProduct()));
        this.log(Utils.DOM2String(this.getDDI3PhysicalDataProduct(new FileFormatInfo())));
        this.log(Utils.DOM2String(this.getDDI3PhysicalInstance(null, new FileFormatInfo())));
    }

    public void dumpMetadata() {
        this.log(this.infoRecord.toString());
        Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
        while (varIterator.hasNext()) {
            SPSSVariable var = this.variableMap.get(varIterator.next());
            this.log(var.variableRecord.toString());
        }
        if (this.documentationRecord != null) {
            this.log(this.documentationRecord.toString());
        }
        if (this.integerInformationRecord != null) {
            this.log(this.integerInformationRecord.toString());
        }
        if (this.floatInformationRecord != null) {
            this.log(this.floatInformationRecord.toString());
        }
        if (this.variableSetsInformationRecord != null) {
            this.log(this.variableSetsInformationRecord.toString());
        }
        if (this.variableDisplayParamsRecord != null) {
            this.log(this.variableDisplayParamsRecord.toString());
        }
        if (this.longVariableNamesRecord != null) {
            this.log(this.longVariableNamesRecord.toString());
        }
        if (this.veryLongStringVariableRecord != null) {
            this.log(this.veryLongStringVariableRecord.toString());
        }
    }

    public long exportData(File file, FileFormatInfo dataFormat) throws IOException, SPSSFileException {
        if (file == null) {
            throw new SPSSFileException("File should not be null.");
        }
        if (file.isDirectory()) {
            throw new SPSSFileException("File should not be a directory: " + file);
        }
        this.log("\nExporting data to " + file.getCanonicalPath());
        this.start = System.currentTimeMillis();
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        if (this.infoRecord.numberOfCases > 0) {
            if (dataFormat.format == FileFormatInfo.Format.ASCII && (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.DELIMITED || dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) && dataFormat.namesOnFirstLine) {
                String recordStr = "";
                Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
                int n = 1;
                while (varIterator.hasNext()) {
                    SPSSVariable var = this.variableMap.get(varIterator.next());
                    if (n > 1) {
                        recordStr = dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.CSV ? recordStr + "," : recordStr + dataFormat.asciiDelimiter;
                    }
                    recordStr = recordStr + var.getName();
                    ++n;
                }
                out.write(recordStr + "\n");
            }
            out.write(this.getRecordFromDisk(dataFormat, true) + "\n");
            for (int i = 2; i <= this.getRecordCount(); ++i) {
                out.write(this.getRecordFromDisk(dataFormat, false) + "\n");
            }
        } else {
            this.log("WARNING: files does not contain any data");
        }
        out.close();
        this.elapsed = System.currentTimeMillis() - this.start;
        this.log("" + this.elapsed + " ms, file size  " + file.length() / 1024L + "Kb");
        return this.elapsed;
    }

    public boolean isCompressed() throws SPSSFileException {
        if (this.infoRecord != null) {
            return this.infoRecord.compressionSwitch != 0;
        }
        throw new SPSSFileException("SPSS file not initialized");
    }

    public Document getDDI2() throws SPSSFileException {
        return this.getDDI2(new FileFormatInfo());
    }

    public Document getDDI2(FileFormatInfo dataFormat) throws SPSSFileException {
        Document doc;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            domFactory.setNamespaceAware(true);
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            doc = domBuilder.newDocument();
            Element codeBook = doc.createElementNS(DDI2_NAMESPACE, "codeBook");
            codeBook.setAttribute("version", "2.0");
            codeBook.setAttribute("ID", this.getUniqueID());
            doc.appendChild(codeBook);
            Element docDscr = (Element)codeBook.appendChild(doc.createElementNS(DDI2_NAMESPACE, "docDscr"));
            Element docCitation = (Element)docDscr.appendChild(doc.createElementNS(DDI2_NAMESPACE, "citation"));
            Element docTitlStmt = (Element)docCitation.appendChild(doc.createElementNS(DDI2_NAMESPACE, "titlStmt"));
            Element elem = (Element)docTitlStmt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "titl"));
            elem.setTextContent("SPSS File " + this.file.getName());
            Element docProdStmt = (Element)docCitation.appendChild(doc.createElementNS(DDI2_NAMESPACE, "prodStmt"));
            elem = (Element)docProdStmt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "prodDate"));
            String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            elem.setAttribute("date", dateStr);
            elem.setTextContent(dateStr);
            elem = (Element)docProdStmt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "software"));
            elem.setAttribute("version", "2008.1");
            elem.setTextContent("UKDA/ODaF DExT Tools");
            Element stdyDscr = (Element)codeBook.appendChild(doc.createElementNS(DDI2_NAMESPACE, "stdyDscr"));
            Element stdyCitation = (Element)stdyDscr.appendChild(doc.createElementNS(DDI2_NAMESPACE, "citation"));
            Element stdyTitlStmt = (Element)stdyCitation.appendChild(doc.createElementNS(DDI2_NAMESPACE, "titlStmt"));
            elem = (Element)stdyTitlStmt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "titl"));
            elem.setTextContent("SPSS File " + this.file.getName());
            Element stdyProdStmt = (Element)stdyCitation.appendChild(doc.createElementNS(DDI2_NAMESPACE, "prodStmt"));
            elem = (Element)stdyProdStmt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "prodDate"));
            elem = (Element)stdyProdStmt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "software"));
            elem.setTextContent(this.infoRecord.productIdentification.substring(5));
            Element fileDscr = (Element)codeBook.appendChild(doc.createElementNS(DDI2_NAMESPACE, "fileDscr"));
            Element fileTxt = (Element)fileDscr.appendChild(doc.createElementNS(DDI2_NAMESPACE, "fileTxt"));
            elem = (Element)fileTxt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "fileName"));
            elem.setTextContent(this.file.getName());
            Element fileDimensions = (Element)fileTxt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "dimensns"));
            elem = (Element)fileDimensions.appendChild(doc.createElementNS(DDI2_NAMESPACE, "caseQnty"));
            elem.setTextContent("" + this.infoRecord.numberOfCases);
            elem = (Element)fileDimensions.appendChild(doc.createElementNS(DDI2_NAMESPACE, "varQnty"));
            elem.setTextContent("" + this.variableMap.size());
            elem = (Element)fileTxt.appendChild(doc.createElementNS(DDI2_NAMESPACE, "fileType"));
            elem.setTextContent(this.infoRecord.productIdentification.substring(5));
            Element dataDscr = (Element)codeBook.appendChild(doc.createElementNS(DDI2_NAMESPACE, "dataDscr"));
            Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
            int offset = 1;
            while (varIterator.hasNext()) {
                SPSSVariable var = this.variableMap.get(varIterator.next());
                dataDscr.appendChild(var.getDDI2(doc, dataFormat, offset));
                offset += var.getLength(dataFormat);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SPSSFileException("Error creating DDI Document: " + e.getMessage());
        }
        return doc;
    }

    public String getDDI3DefaultLogicalProductID() {
        return this.getUniqueID() + "_" + this.logicalProductIDSuffix;
    }

    public String getDDI3DefaultPhysicalDataProductID(FileFormatInfo dataFormat) {
        return this.getUniqueID() + "_" + this.physicalDataProductIDSuffix + "_" + dataFormat.toString();
    }

    public String getDDI3DefaultPhysicalInstanceID(FileFormatInfo dataFormat) {
        return this.getUniqueID() + "_" + this.physicalInstanceIDSuffix + "_" + dataFormat.toString();
    }

    public String getDDI3DefaultPhysicalStructureSchemeID(FileFormatInfo dataFormat) {
        return this.getUniqueID() + "_" + this.physicalStructureSchemeSuffix + "_" + dataFormat.toString();
    }

    public String getDDI3DefaultRecordLayoutSchemeID(FileFormatInfo dataFormat) {
        return this.getUniqueID() + "_" + this.recordLayoutSchemeSuffix + "_" + dataFormat.toString();
    }

    public String getDDI3DefaultVariableSchemeID() {
        return this.getUniqueID() + "_" + this.variableSchemeIDSuffix;
    }

    public Document getDDI3LogicalProduct() throws SPSSFileException {
        return this.getDDI3LogicalProduct(null, null);
    }

    public Document getDDI3LogicalProduct(String uniqueID) throws SPSSFileException {
        return this.getDDI3LogicalProduct(uniqueID, null);
    }

    public Document getDDI3LogicalProduct(String uniqueID, String identifyingAgency) throws SPSSFileException {
        Document doc;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            SPSSVariable var;
            domFactory.setNamespaceAware(true);
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            doc = domBuilder.newDocument();
            Element logicalProduct = (Element)doc.appendChild(doc.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "LogicalProduct"));
            Utils.setDDIMaintainableId(logicalProduct, this.getDDI3DefaultLogicalProductID());
            Element dataRelationship = (Element)logicalProduct.appendChild(doc.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "DataRelationship"));
            Utils.setDDIIdentifiableId(dataRelationship, this.dataRelationshipID);
            Element logicalRecord = (Element)dataRelationship.appendChild(doc.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "LogicalRecord"));
            Utils.setDDIIdentifiableId(logicalRecord, this.logicalRecordID);
            logicalRecord.setAttribute("hasLocator", "false");
            Element varsInRecord = (Element)logicalRecord.appendChild(doc.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "VariablesInRecord"));
            varsInRecord.setAttribute("allVariablesInLogicalProduct", "true");
            Element variableSchemeReference = (Element)varsInRecord.appendChild(doc.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "VariableSchemeReference"));
            Element elem = (Element)variableSchemeReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            elem.setTextContent(this.getDDI3DefaultVariableSchemeID());
            Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
            while (varIterator.hasNext()) {
                var = this.variableMap.get(varIterator.next());
                if (!var.hasValueLabels()) continue;
                logicalProduct.appendChild(var.getDDI3CategoryScheme(doc));
            }
            varIterator = this.variableMap.keySet().iterator();
            while (varIterator.hasNext()) {
                var = this.variableMap.get(varIterator.next());
                if (!var.hasValueLabels()) continue;
                logicalProduct.appendChild(var.getDDI3CodeScheme(doc));
            }
            Element varScheme = (Element)logicalProduct.appendChild(doc.createElementNS(DDI3_LOGICAL_PRODUCT_NAMESPACE, "VariableScheme"));
            Utils.setDDIMaintainableId(varScheme, this.getDDI3DefaultVariableSchemeID());
            varIterator = this.variableMap.keySet().iterator();
            while (varIterator.hasNext()) {
                SPSSVariable var2 = this.variableMap.get(varIterator.next());
                varScheme.appendChild(var2.getDDI3Variable(doc));
            }
        }
        catch (ParserConfigurationException e) {
            throw new SPSSFileException("Error creating DDI Document: " + e.getMessage());
        }
        return doc;
    }

    public Document getDDI3PhysicalDataProduct(FileFormatInfo dataFormat) throws SPSSFileException {
        return this.getDDI3PhysicalDataProduct(dataFormat, null, null, null);
    }

    public Document getDDI3PhysicalDataProduct(FileFormatInfo dataFormat, String logicalProductID) throws SPSSFileException {
        return this.getDDI3PhysicalDataProduct(dataFormat, logicalProductID, null, null);
    }

    public Document getDDI3PhysicalDataProduct(FileFormatInfo dataFormat, String logicalProductID, String uniqueID) throws SPSSFileException {
        return this.getDDI3PhysicalDataProduct(dataFormat, logicalProductID, uniqueID, null);
    }

    private Document getDDI3PhysicalDataProduct(FileFormatInfo dataFormat, String logicalProductID, String uniqueID, String identifyingAgency) throws SPSSFileException {
        Document doc;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            domFactory.setNamespaceAware(true);
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            doc = domBuilder.newDocument();
            Element physicalProduct = (Element)doc.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalDataProduct"));
            if (uniqueID == null) {
                uniqueID = this.getDDI3DefaultPhysicalDataProductID(dataFormat);
            }
            Utils.setDDIMaintainableId(physicalProduct, uniqueID);
            Element physicalStructureScheme = (Element)physicalProduct.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalStructureScheme"));
            Utils.setDDIMaintainableId(physicalStructureScheme, this.getDDI3DefaultPhysicalStructureSchemeID(dataFormat));
            Element physicalStructure = (Element)physicalStructureScheme.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalStructure"));
            Utils.setDDIVersionableId(physicalStructure, this.physicalStructureID);
            Element logicalReference = (Element)physicalStructure.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "LogicalProductReference"));
            Element elem = (Element)logicalReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            if (logicalProductID == null) {
                logicalProductID = this.getDDI3DefaultLogicalProductID();
            }
            elem.setTextContent(logicalProductID);
            elem = (Element)physicalStructure.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "Format"));
            elem.setTextContent(dataFormat.toString());
            elem = (Element)physicalStructure.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "DefaultDecimalSeparator"));
            elem.setTextContent(".");
            Element grossRecordStructure = (Element)physicalStructure.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "GrossRecordStructure"));
            Utils.setDDIIdentifiableId(grossRecordStructure, this.grossRecordStructureID);
            grossRecordStructure.setAttribute("numberOfPhysicalSegments", "1");
            Element logicalRecordReference = (Element)grossRecordStructure.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "LogicalRecordReference"));
            elem = (Element)logicalRecordReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            elem.setTextContent(this.logicalRecordID);
            Element physicalRecordSegment = (Element)grossRecordStructure.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalRecordSegment"));
            Utils.setDDIIdentifiableId(physicalRecordSegment, this.physicalRecordSegmentID);
            physicalRecordSegment.setAttribute("segmentOrder", "1");
            physicalRecordSegment.setAttribute("hasSegmentKey", "false");
            Element recordLayoutSheme = (Element)physicalProduct.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "RecordLayoutScheme"));
            Utils.setDDIMaintainableId(recordLayoutSheme, this.getDDI3DefaultRecordLayoutSchemeID(dataFormat));
            Element recordLayout = dataFormat.format == FileFormatInfo.Format.ASCII ? (Element)recordLayoutSheme.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "RecordLayout")) : (Element)recordLayoutSheme.appendChild(doc.createElementNS(DDI3_PROPRIETARY_RECORD_NAMESPACE, "ProprietaryRecordLayout"));
            Utils.setDDIIdentifiableId(recordLayout, dataFormat.toString());
            Element physicalStructureReference = (Element)recordLayout.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalStructureReference"));
            elem = (Element)physicalStructureReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "Scheme"));
            elem = (Element)elem.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            elem.setTextContent(this.getDDI3DefaultPhysicalStructureSchemeID(dataFormat));
            elem = (Element)physicalStructureReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            elem.setTextContent(this.physicalStructureID);
            elem = (Element)physicalStructureReference.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "PhysicalRecordSegmentUsed"));
            elem.setTextContent(this.physicalRecordSegmentID);
            elem = (Element)recordLayout.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "CharacterSet"));
            elem.setTextContent("ASCII");
            elem = (Element)recordLayout.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "ArrayBase"));
            elem.setTextContent("1");
            if (dataFormat.format == FileFormatInfo.Format.ASCII) {
                Element defaultVariableSchemeReference = (Element)recordLayout.appendChild(doc.createElementNS(DDI3_PHYSICAL_PRODUCT_NAMESPACE, "DefaultVariableSchemeReference"));
                elem = (Element)defaultVariableSchemeReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
                elem.setTextContent(this.getDDI3DefaultVariableSchemeID());
                Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
                int offset = 1;
                while (varIterator.hasNext()) {
                    SPSSVariable var = this.variableMap.get(varIterator.next());
                    recordLayout.appendChild(var.getDDI3DataItem(doc, dataFormat, offset));
                    if (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.FIXED) {
                        offset += var.getLength(dataFormat);
                        continue;
                    }
                    ++offset;
                }
            } else {
                Element software = (Element)recordLayout.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "Software"));
                elem = (Element)software.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "Name"));
                elem.setTextContent(dataFormat.toString());
                if (this.integerInformationRecord != null) {
                    String version = this.integerInformationRecord.releaseMajor + "." + this.integerInformationRecord.releaseMinor;
                    if (this.integerInformationRecord.releaseSpecial > 0) {
                        version = version + "." + this.integerInformationRecord.releaseSpecial;
                    }
                    elem = (Element)software.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "Version"));
                    elem.setTextContent(version);
                }
                elem = (Element)software.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "Description"));
                elem.setTextContent(this.infoRecord.productIdentification);
                Element defaultVariableSchemeReference = (Element)recordLayout.appendChild(doc.createElementNS(DDI3_PROPRIETARY_RECORD_NAMESPACE, "DefaultVariableSchemeReference"));
                elem = (Element)defaultVariableSchemeReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
                elem.setTextContent(this.getDDI3DefaultVariableSchemeID());
                Element proprietaryInfo = (Element)recordLayout.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryInfo"));
                elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                elem.setAttribute("name", "Compression");
                elem.setTextContent("" + this.infoRecord.compressionSwitch);
                elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                elem.setAttribute("name", "CompressionBias");
                elem.setTextContent("" + this.infoRecord.compressionBias);
                if (this.integerInformationRecord != null) {
                    elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    elem.setAttribute("name", "MachineCode");
                    elem.setTextContent("" + this.integerInformationRecord.machineCode);
                    elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    elem.setAttribute("name", "FloatingPointRepresentation");
                    elem.setTextContent("" + this.integerInformationRecord.floatRepresentation + " [" + this.integerInformationRecord.getFloatRepresentationLabel() + "]");
                    elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    elem.setAttribute("name", "Endianness");
                    elem.setTextContent("" + this.integerInformationRecord.endianness + " [" + this.integerInformationRecord.getEndiannessLabel() + "]");
                    elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    elem.setAttribute("name", "CharacterSet");
                    elem.setTextContent("" + this.integerInformationRecord.characterRepresentation + " [" + this.integerInformationRecord.getCharacterRepresentationLabel() + "]");
                }
                if (this.floatInformationRecord != null) {
                    elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    elem.setAttribute("name", "Sysmiss");
                    elem.setTextContent("" + this.floatInformationRecord.sysmiss);
                    elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    elem.setAttribute("name", "HighestSysmissRecode");
                    elem.setTextContent("" + this.floatInformationRecord.highest);
                    elem = (Element)proprietaryInfo.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ProprietaryProperty"));
                    elem.setAttribute("name", "LowsetSysmissRecode");
                    elem.setTextContent("" + this.floatInformationRecord.lowest);
                }
                Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
                while (varIterator.hasNext()) {
                    SPSSVariable var = this.variableMap.get(varIterator.next());
                    recordLayout.appendChild(var.getDDI3ProprietaryDataItem(doc));
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new SPSSFileException("Error creating DDI Document: " + e.getMessage());
        }
        return doc;
    }

    public Document getDDI3PhysicalInstance(URI uri, FileFormatInfo dataFormat) throws SPSSFileException {
        return this.getDDI3PhysicalInstance(uri, dataFormat, null, null, null);
    }

    public Document getDDI3PhysicalInstance(URI uri, FileFormatInfo dataFormat, String recordLayoutSchemeID) throws SPSSFileException {
        return this.getDDI3PhysicalInstance(uri, dataFormat, recordLayoutSchemeID, null, null);
    }

    public Document getDDI3PhysicalInstance(URI uri, FileFormatInfo dataFormat, String recordLayoutSchemeID, String uniqueID) throws SPSSFileException {
        return this.getDDI3PhysicalInstance(uri, dataFormat, recordLayoutSchemeID, uniqueID, null);
    }

    private Document getDDI3PhysicalInstance(URI uri, FileFormatInfo dataFormat, String recordLayoutSchemeID, String uniqueID, String identifyingAgency) throws SPSSFileException {
        Document doc;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            domFactory.setNamespaceAware(true);
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            doc = domBuilder.newDocument();
            Element physicalInstance = (Element)doc.appendChild(doc.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "PhysicalInstance"));
            if (uniqueID == null) {
                uniqueID = this.getDDI3DefaultPhysicalInstanceID(dataFormat);
            }
            Utils.setDDIMaintainableId(physicalInstance, uniqueID);
            Element recordLayoutReference = (Element)physicalInstance.appendChild(doc.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "RecordLayoutReference"));
            if (recordLayoutSchemeID == null) {
                recordLayoutSchemeID = this.getDDI3DefaultRecordLayoutSchemeID(dataFormat);
            }
            Element elem = (Element)recordLayoutReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "Scheme"));
            elem = (Element)elem.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            elem.setTextContent(recordLayoutSchemeID);
            elem = (Element)recordLayoutReference.appendChild(doc.createElementNS(DDI3_REUSABLE_NAMESPACE, "ID"));
            elem.setTextContent(dataFormat.toString());
            Element dataFileIdentification = (Element)physicalInstance.appendChild(doc.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "DataFileIdentification"));
            Utils.setDDIIdentifiableId(dataFileIdentification, this.physicalInstanceFileID);
            if (dataFormat.format == FileFormatInfo.Format.SPSS) {
                dataFileIdentification.setAttribute("isMaster", "true");
            }
            if (uri != null) {
                elem = (Element)dataFileIdentification.appendChild(doc.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "URI"));
                elem.setTextContent(uri.toString());
            }
            Element grossFile = (Element)physicalInstance.appendChild(doc.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "GrossFileStructure"));
            Utils.setDDIIdentifiableId(grossFile, this.grossFileID);
            elem = (Element)grossFile.appendChild(doc.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "CaseQuantity"));
            elem.setTextContent("" + this.getRecordCount());
            elem = (Element)grossFile.appendChild(doc.createElementNS(DDI3_PHYSICAL_INSTANCE_NAMESPACE, "OverallRecordCount"));
            elem.setTextContent("" + this.getRecordCount());
        }
        catch (ParserConfigurationException e) {
            throw new SPSSFileException("Error creating DDI PhysicalInstance: " + e.getMessage());
        }
        catch (DOMException e) {
            throw new SPSSFileException("Error creating DDI PhysicalInstance: " + e.getMessage());
        }
        return doc;
    }

    public String getRecord(int obsNumber, FileFormatInfo dataFormat) throws SPSSFileException {
        if (!this.isMetadataLoaded) {
            throw new SPSSFileException("Metadata has not been loaded");
        }
        if (!this.isDataLoaded) {
            throw new SPSSFileException("Data has not been loaded");
        }
        String recordStr = "";
        if (obsNumber < 1 || obsNumber > this.getRecordCount()) {
            throw new SPSSFileException("Invalid record number [" + obsNumber + ". Range is 1 to " + this.getRecordCount() + "]");
        }
        Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
        int n = 1;
        while (varIterator.hasNext()) {
            if (n > 1) {
                if (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.DELIMITED) {
                    recordStr = recordStr + dataFormat.asciiDelimiter;
                } else if (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) {
                    recordStr = recordStr + ",";
                }
            }
            SPSSVariable var = this.variableMap.get(varIterator.next());
            recordStr = recordStr + var.getValueAsString(obsNumber, dataFormat);
            ++n;
        }
        return recordStr;
    }

    public String getRecordFromDisk(FileFormatInfo dataFormat, boolean rewind) throws SPSSFileException, IOException {
        if (!this.isMetadataLoaded) {
            this.loadMetadata();
        }
        String recordStr = "";
        SPSSDataRecord data = new SPSSDataRecord();
        if (rewind) {
            this.seek(this.dataStartPosition);
            SPSSDataRecord.clusterIndex = (byte)8;
        }
        data.read(this, true);
        Iterator<Integer> varIterator = this.variableMap.keySet().iterator();
        int n = 1;
        while (varIterator.hasNext()) {
            if (n > 1) {
                if (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.DELIMITED) {
                    recordStr = recordStr + dataFormat.asciiDelimiter;
                } else if (dataFormat.asciiFormat == FileFormatInfo.ASCIIFormat.CSV) {
                    recordStr = recordStr + ",";
                }
            }
            SPSSVariable var = this.variableMap.get(varIterator.next());
            recordStr = recordStr + var.getValueAsString(0, dataFormat);
            ++n;
        }
        return recordStr;
    }

    public int getRecordCount() {
        return this.infoRecord.numberOfCases;
    }

    public String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = "ID_" + UUID.randomUUID().toString();
        }
        return this.uniqueID;
    }

    public SPSSVariable getVariable(int index) {
        if (index >= this.variableMap.size() || index < 0) {
            return null;
        }
        return (SPSSVariable)this.variableMap.values().toArray()[index];
    }

    public int getVariableCount() {
        return this.variableMap.size();
    }

    public void loadData() throws IOException, SPSSFileException {
        if (this.dataStartPosition < 1L) {
            throw new SPSSFileException("Error: data location pointer not initialized.");
        }
        SPSSDataRecord.clusterIndex = (byte)8;
        SPSSDataRecord data = new SPSSDataRecord();
        this.seek(this.dataStartPosition);
        for (int i = 0; i < this.infoRecord.numberOfCases; ++i) {
            data.read(this);
        }
        this.isDataLoaded = true;
    }

    public void loadMetadata() throws FileNotFoundException, IOException, SPSSFileException {
        long filePointer;
        int recordType;
        if (this.isMetadataLoaded) {
            throw new SPSSFileException("Metadata is already loaded");
        }
        int varIndex = 0;
        this.seek(0L);
        this.infoRecord = new SPSSRecordType1();
        this.infoRecord.read(this);
        this.log(this.infoRecord.toString());
        this.variableMap = new LinkedHashMap<Integer, SPSSVariable>();
        this.variableShortNameMap = new LinkedHashMap<String, SPSSVariable>();
        int count = 0;
        do {
            SPSSRecordType2 type2Record = new SPSSRecordType2();
            type2Record.read(this);
            if (type2Record.variableTypeCode >= 0) {
                this.log(type2Record.toString());
                SPSSVariable var = type2Record.variableTypeCode == 0 ? new SPSSNumericVariable(this) : new SPSSStringVariable(this);
                var.variableRecord = type2Record;
                var.variableShortName = type2Record.name;
                var.variableName = type2Record.name;
                this.variableMap.put(count, var);
                var.variableNumber = this.variableMap.size();
                if (type2Record.missingValueFormatCode > 0) {
                    for (int j = 0; j < type2Record.missingValueFormatCode; ++j) {
                        SPSSVariableCategory cat = var.addCategory(type2Record.missingValue[j], "");
                        cat.isMissing = true;
                    }
                } else if (type2Record.missingValueFormatCode <= -2) {
                    int from = (int)SPSSUtils.byte8ToDouble(type2Record.missingValue[0]);
                    int to = (int)SPSSUtils.byte8ToDouble(type2Record.missingValue[1]);
                    for (int j = from; j <= to; ++j) {
                        SPSSVariableCategory cat = ((SPSSNumericVariable)var).addCategory(j, "");
                        cat.isMissing = true;
                    }
                    if (type2Record.missingValueFormatCode == -3) {
                        SPSSVariableCategory cat = var.addCategory(type2Record.missingValue[2], "");
                        cat.isMissing = true;
                    }
                }
            }
            ++count;
            filePointer = this.getFilePointer();
            recordType = this.readSPSSInt();
            this.seek(filePointer);
        } while (recordType == 2);
        if (this.infoRecord.OBSperObservation == -1) {
            this.infoRecord.OBSperObservation = count;
        }
        this.log("\n# VARIABLES: " + this.variableMap.size());
        block18: do {
            filePointer = this.getFilePointer();
            recordType = this.readSPSSInt();
            switch (recordType) {
                case 3: {
                    this.seek(filePointer);
                    SPSSRecordType3 record3 = new SPSSRecordType3();
                    record3.read(this);
                    this.log(record3.toString());
                    SPSSRecordType4 record4 = new SPSSRecordType4();
                    record4.read(this);
                    this.log(record4.toString());
                    for (int i = 0; i < record4.numberOfVariables; ++i) {
                        SPSSVariable var = this.variableMap.get(record4.variableIndex[i] - 1);
                        var.valueLabelRecord = record3;
                        for (byte[] key : record3.valueLabel.keySet()) {
                            var.addCategory(key, record3.valueLabel.get(key));
                        }
                    }
                    continue block18;
                }
                case 6: {
                    this.seek(filePointer);
                    SPSSRecordType6 record6 = new SPSSRecordType6();
                    record6.read(this);
                    this.log(record6.toString());
                    break;
                }
                case 7: {
                    int subrecordType = this.readSPSSInt();
                    this.seek(filePointer);
                    switch (subrecordType) {
                        case 3: {
                            this.integerInformationRecord = new SPSSRecordType7Subtype3();
                            this.integerInformationRecord.read(this);
                            this.log(this.integerInformationRecord.toString());
                            break;
                        }
                        case 4: {
                            this.floatInformationRecord = new SPSSRecordType7Subtype4();
                            this.floatInformationRecord.read(this);
                            this.log(this.floatInformationRecord.toString());
                            break;
                        }
                        case 5: {
                            this.variableSetsInformationRecord = new SPSSRecordType7Subtype5();
                            this.variableSetsInformationRecord.read(this);
                            this.log(this.variableSetsInformationRecord.toString());
                            break;
                        }
                        case 11: {
                            this.variableDisplayParamsRecord = new SPSSRecordType7Subtype11();
                            this.variableDisplayParamsRecord.read(this);
                            this.log(this.variableDisplayParamsRecord.toString());
                            varIndex = 0;
                            for (SPSSRecordType7Subtype11.VariableDisplayParams params : this.variableDisplayParamsRecord.variableDisplayParams) {
                                this.getVariable((int)varIndex).measure = params.measure;
                                this.getVariable((int)varIndex).displayWidth = params.width;
                                this.getVariable((int)varIndex).alignment = params.alignment;
                                ++varIndex;
                            }
                            continue block18;
                        }
                        case 13: {
                            this.longVariableNamesRecord = new SPSSRecordType7Subtype13();
                            this.longVariableNamesRecord.read(this);
                            this.log(this.longVariableNamesRecord.toString());
                            SPSSVariable currentVar = null;
                            int deletedCount = 0;
                            Iterator<Map.Entry<Integer, SPSSVariable>> it = this.variableMap.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry<Integer, SPSSVariable> entry = it.next();
                                SPSSVariable var = (SPSSVariable)entry.getValue();
                                String shortName = var.getShortName();
                                String longName = this.longVariableNamesRecord.nameMap.get(shortName);
                                if (longName != null && !longName.isEmpty()) {
                                    currentVar = var;
                                    var.variableName = longName;
                                    var.variableNumber -= deletedCount;
                                    this.variableShortNameMap.put(shortName, var);
                                    continue;
                                }
                                if (currentVar instanceof SPSSStringVariable) {
                                    ((SPSSStringVariable)currentVar).segments.add(var);
                                    it.remove();
                                    ++deletedCount;
                                    continue;
                                }
                                throw new SPSSFileException("Variable " + var.getName() + " is not in the variable dictionary and is not a segment of a string variable.");
                            }
                            continue block18;
                        }
                        case 14: {
                            Object variable;
                            this.veryLongStringVariableRecord = new SPSSRecordType7Subtype14();
                            this.veryLongStringVariableRecord.read(this);
                            this.log(this.veryLongStringVariableRecord.toString());
                            for (Map.Entry<String, Integer> entry : this.veryLongStringVariableRecord.entries()) {
                                variable = this.variableShortNameMap.get(entry.getKey());
                                if (variable == null || !(variable instanceof SPSSStringVariable)) continue;
                                ((SPSSStringVariable)variable).setLength((Integer)entry.getValue());
                            }
                            continue block18;
                        }
                        case 21: {
                            Object variable;
                            Map.Entry<String, Integer> entry;
                            SPSSRecordType7Subtype21 recordType7Subtype21 = new SPSSRecordType7Subtype21();
                            recordType7Subtype21.read(this);
                            this.log(recordType7Subtype21.toString());
                            entry = recordType7Subtype21.getVariables().iterator();
                            while (entry.hasNext()) {
                                variable = entry.next();
                                SPSSVariable var = this.getVariableByName(((SPSSRecordType7Subtype21.Variable)variable).getName());
                                if (var == null) {
                                    throw new SPSSFileException("Invalid variable name " + ((SPSSRecordType7Subtype21.Variable)variable).getName());
                                }
                                for (SPSSRecordType7Subtype21.Label label : ((SPSSRecordType7Subtype21.Variable)variable).getLabels()) {
                                    var.addCategory(label.getValue().getBytes(), label.getLabel());
                                }
                            }
                            continue block18;
                        }
                        default: {
                            SPSSRecordType7 record7 = new SPSSRecordType7();
                            record7.read(this);
                            this.log(record7.toString());
                            break;
                        }
                    }
                    continue block18;
                }
                case 999: {
                    this.log("\nRECORD TYPE 999 - START OF DATA");
                    this.log("location " + this.getFilePointer());
                    if (this.readSPSSInt() != 0) {
                        throw new SPSSFileException("Error reading record type 999: Non-zero value found.");
                    }
                    this.dataStartPosition = this.getFilePointer();
                    break;
                }
                default: {
                    throw new SPSSFileException("Read error: invalid record type [" + recordType + "]");
                }
            }
        } while (recordType != 999);
        this.isMetadataLoaded = true;
    }

    public void log(String msg) {
        if (this.logFlag.booleanValue()) {
            Calendar now = Calendar.getInstance();
            now.setTime(new Date());
            msg = "" + now.get(11) + ":" + now.get(12) + ":" + now.get(13) + " " + msg;
            if (this.logFile == null) {
                System.out.println(msg);
            } else {
                try {
                    if (this.logWriter == null) {
                        this.logWriter = new BufferedWriter(new FileWriter(this.logFile));
                    }
                    this.logWriter.write(msg + "\n");
                    this.logWriter.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public double readSPSSDouble() throws IOException {
        byte[] buffer = new byte[8];
        if (this.isBigEndian) {
            for (int i = 7; i >= 0; --i) {
                buffer[i] = this.readByte();
            }
        } else {
            this.read(buffer);
        }
        return SPSSUtils.byte8ToDouble(buffer);
    }

    public int readSPSSInt() throws IOException {
        byte[] buffer = new byte[4];
        if (this.isBigEndian) {
            for (int i = 3; i >= 0; --i) {
                buffer[i] = this.readByte();
            }
        } else {
            this.read(buffer);
        }
        return SPSSUtils.byte4ToInt(buffer);
    }

    public String readSPSSString(int length) throws IOException {
        String s = "";
        byte[] buffer = new byte[length];
        this.read(buffer);
        s = this.charset != null ? new String(buffer, this.charset) : new String(buffer);
        return s;
    }

    public void setUniqueID(String str) {
        this.uniqueID = str;
    }

    private SPSSVariable getVariableByName(String variableName) {
        for (SPSSVariable var : this.variableMap.values()) {
            if (!var.getName().equals(variableName)) continue;
            return var;
        }
        return null;
    }
}

