/*
 * Decompiled with CFR 0.152.
 */
package clisk.generator;

import clisk.IFunction;
import java.util.Random;

public final class Voronoi2D {
    private final int count;
    private final double[] xs;
    private final double[] ys;

    public Voronoi2D(int numPoints) {
        this.count = numPoints;
        this.xs = new double[numPoints];
        this.ys = new double[numPoints];
        Random r = new Random();
        int i = 0;
        while (i < this.count) {
            this.xs[i] = r.nextDouble();
            this.ys[i] = r.nextDouble();
            ++i;
        }
    }

    private static double dist2(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        if ((dx -= Math.floor(dx)) > 0.5) {
            dx = 1.0 - dx;
        }
        double dy = y2 - y1;
        if ((dy -= Math.floor(dy)) > 0.5) {
            dy = 1.0 - dy;
        }
        return dx * dx + dy * dy;
    }

    private int seek(double x, double y) {
        int i0 = 0;
        int i1 = 1;
        double dd0 = Voronoi2D.dist2(x, y, this.xs[0], this.ys[0]);
        double dd1 = Voronoi2D.dist2(x, y, this.xs[0], this.ys[0]);
        if (dd1 < dd0) {
            i0 = 1;
            i1 = 0;
            double t = dd0;
            dd1 = dd0 = dd1;
        }
        int i = 2;
        while (i < this.count) {
            double px = this.xs[i];
            double py = this.ys[i];
            double dd = Voronoi2D.dist2(px, py, x, y);
            if (dd < dd1) {
                if (dd < dd0) {
                    i1 = i0;
                    dd1 = dd0;
                    i0 = i;
                    dd0 = dd;
                } else {
                    i1 = i;
                    dd1 = dd;
                }
            }
            ++i;
        }
        return i0 + (i1 << 16);
    }

    private int seekNearest(double x, double y) {
        return this.seek(x, y) & 0xFFFF;
    }

    private int seekSecond(double x, double y) {
        return this.seek(x, y) >> 16 & 0xFFFF;
    }

    public double nearestX(double x, double y) {
        return this.xs[this.seekNearest(x, y)];
    }

    public double nearestY(double x, double y) {
        return this.ys[this.seekNearest(x, y)];
    }

    public double nearestDistanceSquared(double x, double y) {
        int i = this.seekNearest(x, y);
        return Voronoi2D.dist2(x, y, this.xs[i], this.ys[i]);
    }

    public double nearestDistance(double x, double y) {
        return Math.sqrt(this.nearestDistanceSquared(x, y));
    }

    public double firstSecondFunction(double x, double y, IFunction func) {
        int i = this.seek(x, y);
        int i0 = i & 0xFFFF;
        int i1 = i >> 16 & 0xFFFF;
        double d0 = Math.sqrt(Voronoi2D.dist2(x, y, this.xs[i0], this.ys[i0]));
        double d1 = Math.sqrt(Voronoi2D.dist2(x, y, this.xs[i1], this.ys[i1]));
        return func.calc(d0, d1);
    }
}

