/*
 * Decompiled with CFR 0.152.
 */
package clisk;

import clisk.IRenderFunction;
import java.awt.image.BufferedImage;

public class TextureFunction
implements IRenderFunction {
    private final BufferedImage texture;
    private final double xoff;
    private final double yoff;
    private final double w;
    private final double h;

    public TextureFunction(BufferedImage texture) {
        this(texture, 0.0, 0.0, texture.getWidth(), texture.getHeight());
    }

    public TextureFunction(BufferedImage texture, double x, double y, double width, double height) {
        this.texture = texture;
        this.xoff = x;
        this.yoff = y;
        this.w = width;
        this.h = height;
    }

    @Override
    public int calc(double x, double y) {
        return this.texture.getRGB((int)(x * this.w + this.xoff), (int)(y * this.h + this.yoff));
    }

    @Override
    public int calc(double x, double y, double z) {
        return this.calc(x, y);
    }

    @Override
    public int calc(double x, double y, double z, double t) {
        return this.calc(x, y);
    }

    @Override
    public int calc() {
        throw new IllegalArgumentException("Insufficient args for TextureFunction: 0");
    }

    @Override
    public int calc(double x) {
        throw new IllegalArgumentException("Insufficient args for TextureFunction: 1");
    }
}

