/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.survivalranks;

import java.util.UUID;
import net.justminecraft.survivalranks.SurvivalRanks;

public class Points {
    private final UUID uuid;
    private String username;
    private int points;

    public Points(UUID uuid) {
        this.uuid = uuid;
        this.username = null;
        this.points = 0;
    }

    public Points(UUID uuid, String username, int points) {
        this.uuid = uuid;
        this.username = username;
        this.points = points;
    }

    private void insertIntoDatabase() {
        SurvivalRanks.getSQLDatabase().prepareStatementAsync("INSERT OR IGNORE INTO points (uuid, username, points)\nVALUES (?, ?, ?)", statement -> {
            statement.setString(1, this.uuid.toString());
            statement.setString(2, this.username);
            statement.setInt(3, this.points);
            statement.execute();
        });
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        SurvivalRanks.getSQLDatabase().prepareStatementAsync("UPDATE points SET username = ? WHERE uuid = ?", statement -> {
            statement.setString(1, username);
            statement.setString(2, this.uuid.toString());
            if (statement.executeUpdate() == 0) {
                this.insertIntoDatabase();
            }
        });
    }

    public int getPoints() {
        return this.points;
    }

    public void incrementPoints(int points_diff) {
        this.points += points_diff;
        SurvivalRanks.getSQLDatabase().prepareStatementAsync("UPDATE points SET points = points + ? WHERE uuid = ?", statement -> {
            statement.setInt(1, points_diff);
            statement.setString(2, this.uuid.toString());
            if (statement.executeUpdate() == 0) {
                this.insertIntoDatabase();
            }
        });
    }

    public void scalePoints(double points_scalar) {
        this.points = (int)((double)this.points * points_scalar);
        SurvivalRanks.getSQLDatabase().prepareStatementAsync("UPDATE points SET points = points * ? WHERE uuid = ?", statement -> {
            statement.setDouble(1, points_scalar);
            statement.setString(2, this.uuid.toString());
            if (statement.executeUpdate() == 0) {
                this.insertIntoDatabase();
            }
        });
    }
}

