/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.survivalranks.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class Database {
    private final Plugin plugin;
    private Connection connection = null;

    public Database(Plugin plugin) {
        this.plugin = plugin;
    }

    public abstract Connection openConnection() throws SQLException;

    private void checkConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = this.openConnection();
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkConnection();
        return this.connection.prepareStatement(sql);
    }

    public void prepareStatementAsync(String sql, SQLConsumer<PreparedStatement> preparedStatementConsumer) {
        SQLException exceptionInMainThread = new SQLException("Unhandled exception occurred async");
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try {
                this.checkConnection();
                Database database = this;
                synchronized (database) {
                    preparedStatementConsumer.accept(this.connection.prepareStatement(sql));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                exceptionInMainThread.printStackTrace();
            }
        });
    }

    public void createTables() {
        try {
            this.checkConnection();
            try (Statement statement = this.connection.createStatement();){
                statement.addBatch("CREATE TABLE IF NOT EXISTS points (uuid CHAR(36) PRIMARY KEY,username VARCHAR(16),points DEFAULT 0)");
                statement.executeBatch();
                statement.clearBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface SQLConsumer<T> {
        public void accept(T var1) throws SQLException;
    }
}

