/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.survivalranks;

import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.justminecraft.survivalranks.NewColors;
import net.justminecraft.survivalranks.Points;
import net.justminecraft.survivalranks.PointsManager;
import net.justminecraft.survivalranks.RankCommand;
import net.justminecraft.survivalranks.RanksManager;
import net.justminecraft.survivalranks.TopRanksCommand;
import net.justminecraft.survivalranks.database.Database;
import net.justminecraft.survivalranks.database.SQLiteDatabase;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SurvivalRanks
extends JavaPlugin {
    private static Database database;
    private Map<UUID, Points> pointsMap = new HashMap<UUID, Points>();
    private Map<UUID, Integer> ranks = new HashMap<UUID, Integer>();
    private List<Points> rankedList = new ArrayList<Points>();

    public void onEnable() {
        database = new SQLiteDatabase((Plugin)this, new File(this.getDataFolder(), "survival-ranks.db"));
        database.createTables();
        this.saveDefaultConfig();
        new PointsManager(this);
        new RanksManager(this);
        new RankCommand(this);
        new TopRanksCommand(this);
        this.loadPoints();
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> Bukkit.getOnlinePlayers().forEach(this::updateRank), (long)(1200.0 + Math.random() * 100.0), (long)(1200.0 + Math.random() * 100.0));
        if (Bukkit.getPluginManager().getPlugin("ViaVersion") != null) {
            this.getLogger().info("Registering 1.16 colours using ViaVersion");
            new NewColors();
        }
    }

    private void loadPoints() {
        SurvivalRanks.getSQLDatabase().prepareStatementAsync("SELECT * FROM points ORDER BY points DESC", preparedStatement -> {
            ResultSet results = preparedStatement.executeQuery();
            while (results.next()) {
                try {
                    UUID uuid = UUID.fromString(results.getString("uuid"));
                    String username = results.getString("username");
                    int points = results.getInt("points");
                    Points pointsObj = new Points(uuid, username, points);
                    Points oldPoints = this.pointsMap.put(uuid, pointsObj);
                    if (oldPoints != null) {
                        this.rankedList.remove(oldPoints);
                    }
                    this.rankedList.add(pointsObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Database getSQLDatabase() {
        return database;
    }

    public Points getPoints(Player player) {
        Points points = this.pointsMap.computeIfAbsent(player.getUniqueId(), Points::new);
        if (!player.getName().equals(points.getUsername())) {
            points.setUsername(player.getName());
        }
        return points;
    }

    public void updateRank(Player player) {
        Points down;
        Points up;
        Points points = this.getPoints(player);
        int index = this.rankedList.indexOf(points);
        if (index == -1) {
            index = this.rankedList.size();
            this.rankedList.add(points);
        }
        while (index > 0) {
            up = this.rankedList.get(index - 1);
            down = this.rankedList.get(index);
            if (up.getPoints() >= down.getPoints()) break;
            Collections.swap(this.rankedList, index--, index);
        }
        while (index < this.rankedList.size() - 1) {
            up = this.rankedList.get(index);
            down = this.rankedList.get(index + 1);
            if (up.getPoints() >= down.getPoints()) break;
            Collections.swap(this.rankedList, index++, index);
        }
        this.ranks.put(player.getUniqueId(), index);
    }

    public int getRank(Player player) {
        return this.ranks.getOrDefault(player, this.rankedList.size());
    }

    public List<Points> getRankedList() {
        return this.rankedList;
    }
}

