/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.survivalranks;

import java.util.HashMap;
import net.justminecraft.survivalranks.SurvivalRanks;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerAchievementAwardedEvent;
import org.bukkit.plugin.Plugin;

public class PointsManager
implements Listener,
Runnable {
    private static final int POINTS_INTERVAL = 5;
    private static final int MOVEMENT_POINTS = 7;
    private static final int BREAK_BLOCK_POINTS = 20;
    private static final int PLACE_BLOCK_POINTS = 30;
    private static final int KILL_MOB_POINTS = 100;
    private static final int ACHIEVEMENT_POINTS = 2500;
    private final SurvivalRanks survivalRanks;
    private HashMap<Player, Integer> pointsThisInterval = new HashMap();
    private HashMap<Player, Location> lastLocations = new HashMap();

    public PointsManager(SurvivalRanks survivalRanks) {
        this.survivalRanks = survivalRanks;
        survivalRanks.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)survivalRanks);
        survivalRanks.getServer().getScheduler().runTaskTimer((Plugin)survivalRanks, (Runnable)this, 100L, 100L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAchievement(PlayerAchievementAwardedEvent event) {
        int points = 2500;
        this.survivalRanks.getPoints(event.getPlayer()).incrementPoints(points);
        Bukkit.getScheduler().runTask((Plugin)this.survivalRanks, () -> event.getPlayer().sendMessage(ChatColor.GREEN + " + " + points + " points"));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        this.setPointsThisInterval(event.getPlayer(), 20);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        this.setPointsThisInterval(event.getPlayer(), 30);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        Entity killer;
        if (event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent && (killer = ((EntityDamageByEntityEvent)event.getEntity().getLastDamageCause()).getDamager()) instanceof Player) {
            this.setPointsThisInterval((Player)killer, 100);
        }
    }

    private void setPointsThisInterval(Player player, int points) {
        if (this.pointsThisInterval.getOrDefault(player, 0) < points) {
            this.pointsThisInterval.put(player, points);
        }
    }

    @Override
    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location location = player.getLocation();
            Location lastLocation = this.lastLocations.get(player);
            if (lastLocation != null && lastLocation.getYaw() == location.getYaw() && lastLocation.getPitch() == location.getPitch() && !(Math.abs(lastLocation.getX() - location.getX()) >= 5.0) && !(Math.abs(lastLocation.getZ() - location.getZ()) >= 5.0)) continue;
            this.lastLocations.put(player, location);
            this.survivalRanks.getPoints(player).incrementPoints(this.pointsThisInterval.getOrDefault(player, 7));
        }
        this.pointsThisInterval.clear();
    }
}

