/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.survivalranks;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.justminecraft.survivalranks.RanksManager;
import us.myles.ViaVersion.api.PacketWrapper;
import us.myles.ViaVersion.api.protocol.Protocol;
import us.myles.ViaVersion.api.protocol.ProtocolRegistry;
import us.myles.ViaVersion.api.remapper.PacketRemapper;
import us.myles.ViaVersion.api.type.Type;
import us.myles.ViaVersion.packets.State;
import us.myles.ViaVersion.protocols.protocol1_15to1_14_4.ClientboundPackets1_15;
import us.myles.ViaVersion.protocols.protocol1_16to1_15_2.Protocol1_16To1_15_2;
import us.myles.viaversion.libs.gson.JsonArray;
import us.myles.viaversion.libs.gson.JsonElement;
import us.myles.viaversion.libs.gson.JsonObject;
import us.myles.viaversion.libs.gson.JsonPrimitive;

public class NewColors {
    public NewColors() {
        Protocol protocol = ProtocolRegistry.getProtocol(Protocol1_16To1_15_2.class);
        try {
            Field outgoing = Protocol.class.getDeclaredField("outgoing");
            outgoing.setAccessible(true);
            Map map = (Map)outgoing.get(protocol);
            Protocol.Packet packet = new Protocol.Packet(State.PLAY, ClientboundPackets1_15.CHAT_MESSAGE.ordinal());
            final Protocol.ProtocolPacket oldPacket = (Protocol.ProtocolPacket)map.get(packet);
            Protocol.ProtocolPacket newPacket = new Protocol.ProtocolPacket(oldPacket.getState(), oldPacket.getOldID(), oldPacket.getNewID(), new PacketRemapper(){

                public void registerMap() {
                    this.handler(wrapper -> {
                        JsonElement json = (JsonElement)wrapper.get(Type.COMPONENT, 0);
                        NewColors.this.recursiveMatchRank(json);
                    });
                }

                public void remap(PacketWrapper packetWrapper) throws Exception {
                    oldPacket.getRemapper().remap(packetWrapper);
                    super.remap(packetWrapper);
                }
            });
            map.put(packet, newPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recursiveMatchRank(JsonElement json) {
        if (json instanceof JsonArray) {
            for (JsonElement element : (JsonArray)json) {
                this.recursiveMatchRank(element);
            }
        }
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            if (object.has("text") && object.has("color")) {
                RanksManager.Rank rank;
                String text = object.get("text").getAsString();
                Pattern pattern = Pattern.compile("\\[(.*?)]");
                Matcher matcher = pattern.matcher(text);
                if (matcher.find() && (rank = RanksManager.getRank(matcher.group(1))) != null) {
                    object.add("color", (JsonElement)new JsonPrimitive(rank.getHexColor()));
                }
            }
            if (object.has("extra")) {
                this.recursiveMatchRank(object.get("extra"));
            }
        }
    }
}

