/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.commands;

import java.util.List;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.commands.SubCommand;
import net.justminecraft.plots.events.PlotPlayerRemoveEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class RemoveCommand
extends SubCommand {
    public RemoveCommand() {
        super("/p remove <player>", "Remove a player from your plot", "remove", "untrust", "unadd", "r");
    }

    @Override
    public boolean onCommand(CommandSender sender, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can execute this command");
            return false;
        }
        Plot plot = JustPlots.getPlotAt((Entity)((Player)sender));
        if (plot == null) {
            sender.sendMessage(ChatColor.RED + "You are not standing on a plot");
            return false;
        }
        if (!plot.isOwner((OfflinePlayer)((Player)sender)) && !sender.hasPermission("justplots.add.other")) {
            sender.sendMessage(ChatColor.RED + JustPlots.getUsername(plot.getOwner()) + " owns that plot");
            return false;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.getUsage());
            return false;
        }
        OfflinePlayer toRemove = Bukkit.getOfflinePlayer((String)args[0]);
        if (!plot.isAdded(toRemove)) {
            sender.sendMessage(ChatColor.RED + toRemove.getName() + " has not been added to that plot");
            return false;
        }
        if (plot.isOwner(toRemove)) {
            sender.sendMessage(ChatColor.RED + toRemove.getName() + " is the owner of that plot");
            return false;
        }
        PlotPlayerRemoveEvent event = new PlotPlayerRemoveEvent(plot, toRemove.getUniqueId());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            throw new RuntimeException("Event was cancelled");
        }
        plot.removePlayer(toRemove.getUniqueId());
        String whos = plot.isOwner((OfflinePlayer)((Player)sender)) ? "your" : JustPlots.getUsername(plot.getOwner()) + "'s";
        sender.sendMessage(ChatColor.GREEN + "Succesfully removed " + toRemove.getName() + " from " + whos + " plot");
        return true;
    }

    @Override
    public void onTabComplete(CommandSender sender, String[] args, List<String> tabCompletion) {
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                tabCompletion.add(player.getName());
            }
        }
    }
}

