/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.commands;

import java.util.List;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.commands.SubCommand;
import net.justminecraft.plots.events.PlotPlayerAddEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AddCommand
extends SubCommand {
    public AddCommand() {
        super("/p add <player>", "Add a player to your plot", "add", "trust", "a");
    }

    @Override
    public boolean onCommand(CommandSender sender, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can execute this command");
            return false;
        }
        Plot plot = JustPlots.getPlotAt((Entity)((Player)sender));
        if (plot == null) {
            sender.sendMessage(ChatColor.RED + "You are not standing on a plot");
            return false;
        }
        if (!plot.isOwner((OfflinePlayer)((Player)sender)) && !sender.hasPermission("justplots.add.other")) {
            sender.sendMessage(ChatColor.RED + JustPlots.getUsername(plot.getOwner()) + " owns that plot");
            return false;
        }
        if (args.length < 1) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.getUsage());
            return false;
        }
        OfflinePlayer toAdd = Bukkit.getOfflinePlayer((String)args[0]);
        if (plot.isAdded(toAdd)) {
            sender.sendMessage(ChatColor.RED + toAdd.getName() + " is already added to that plot");
            return false;
        }
        PlotPlayerAddEvent event = new PlotPlayerAddEvent(plot, toAdd.getUniqueId());
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            throw new RuntimeException("Event was cancelled");
        }
        plot.addPlayer(toAdd.getUniqueId());
        String whos = plot.isOwner((OfflinePlayer)((Player)sender)) ? "your" : JustPlots.getUsername(plot.getOwner()) + "'s";
        sender.sendMessage(ChatColor.GREEN + "Succesfully added " + toAdd.getName() + " to " + whos + " plot");
        return true;
    }

    @Override
    public void onTabComplete(CommandSender sender, String[] args, List<String> tabCompletion) {
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                tabCompletion.add(player.getName());
            }
        }
    }
}

