/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots;

import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.PlotWorld;
import net.justminecraft.plots.paperlib.PaperLib;
import net.justminecraft.plots.util.AsyncUtil;
import net.justminecraft.plots.util.WorldHeight;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class ResetManager {
    public static void reset(PlotWorld plotWorld, int fromx, int fromz, int tox, int toz) {
        double i = 1.0;
        for (int cx = fromx >> 4; cx <= tox >> 4; ++cx) {
            for (int cz = fromz >> 4; cz <= toz >> 4; ++cz) {
                int minx = Math.max(cx << 4, fromx);
                int minz = Math.max(cz << 4, fromz);
                int maxx = Math.min(cx << 4 | 0xF, tox);
                int maxz = Math.min(cz << 4 | 0xF, toz);
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)JustPlots.getPlugin(), (Runnable)new ChunkToReset(plotWorld, minx, minz, maxx, maxz), (long)((int)(i += 0.5)));
            }
        }
        JustPlots.getPlugin().getLogger().info("Resetting plot in " + (int)i + " ticks (" + (int)i / 20 + " seconds)");
    }

    private static class ChunkToReset
    implements Runnable {
        private final PlotWorld plotWorld;
        private final int minx;
        private final int minz;
        private final int maxx;
        private final int maxz;

        public ChunkToReset(PlotWorld plotWorld, int minx, int minz, int maxx, int maxz) {
            this.plotWorld = plotWorld;
            this.minx = minx;
            this.minz = minz;
            this.maxx = maxx;
            this.maxz = maxz;
        }

        @Override
        public void run() {
            World world = Bukkit.getWorld((String)this.plotWorld.getWorld());
            PaperLib.getChunkAtAsync(world, this.minx >> 4, this.minz >> 4, false).thenAccept(chunk -> {
                if (chunk == null) {
                    return;
                }
                AsyncUtil.ensureMainThread(() -> {
                    for (int x = this.minx; x <= this.maxx; ++x) {
                        for (int z = this.minz; z <= this.maxz; ++z) {
                            for (int y = WorldHeight.getMinHeight(world); y < WorldHeight.getMaxHeight(world); ++y) {
                                Block block = chunk.getBlock(x & 0xF, y, z & 0xF);
                                Material material = Material.AIR;
                                if (y == WorldHeight.getMinHeight(world)) {
                                    material = Material.BEDROCK;
                                } else if (y < this.plotWorld.getFloorHeight()) {
                                    material = Material.DIRT;
                                } else if (y == this.plotWorld.getFloorHeight()) {
                                    material = Material.GRASS_BLOCK;
                                }
                                if (!block.getType().equals((Object)material)) {
                                    block.setType(material, false);
                                }
                                world.setBiome(x, y, z, Biome.PLAINS);
                            }
                        }
                    }
                });
            });
        }
    }
}

