/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.listeners;

import java.util.Iterator;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.util.PaperUtil;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class PlotListener
implements Listener {
    private ProjectileSource lastEggThrower = null;

    public PlotListener(JustPlots plots) {
        plots.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plots);
    }

    private void playerModify(Player player, Block block, Cancellable cancellable) {
        this.playerModify(player, block.getLocation(), cancellable);
    }

    private void playerModify(Player player, Entity entity, Cancellable cancellable) {
        this.playerModify(player, entity.getLocation(), cancellable);
    }

    private void playerModify(Player player, Location location, Cancellable cancellable) {
        if (!JustPlots.isPlotWorld(location.getWorld())) {
            return;
        }
        Plot plot = JustPlots.getPlotAt(location);
        if (!(plot != null && plot.isAdded((OfflinePlayer)player) || player.hasPermission("justplots.edit.other"))) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, new ComponentBuilder("You cannot build here").color(ChatColor.RED).create());
            cancellable.setCancelled(true);
        }
    }

    private void entityModify(Entity entity, Block block, Cancellable cancellable) {
        this.entityModify(entity, block.getLocation(), cancellable);
    }

    private void entityModify(Entity entity, Location location, Cancellable cancellable) {
        if (!JustPlots.isPlotWorld(location.getWorld())) {
            return;
        }
        Plot originPlot = JustPlots.getPlotAt(PaperUtil.getOrigin(entity));
        Plot plot = JustPlots.getPlotAt(location);
        if (plot == null || originPlot != plot) {
            cancellable.setCancelled(true);
        }
    }

    private void blockModify(Block from, Block to, Cancellable cancellable) {
        Plot toPlot;
        if (!JustPlots.isPlotWorld(to.getWorld())) {
            return;
        }
        Plot fromPlot = JustPlots.getPlotAt(from.getLocation());
        if (fromPlot != (toPlot = JustPlots.getPlotAt(to.getLocation()))) {
            cancellable.setCancelled(true);
        }
    }

    private void blockModify(Block block, Cancellable cancellable) {
        if (!JustPlots.isPlotWorld(block.getWorld())) {
            return;
        }
        cancellable.setCancelled(true);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.playerModify(event.getPlayer(), event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.playerModify(event.getPlayer(), event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block;
        if (event.getClickedBlock() != null) {
            this.playerModify(event.getPlayer(), event.getClickedBlock(), (Cancellable)event);
        }
        if (event.getClickedBlock() == null && !(block = event.getPlayer().getTargetBlock(null, 5)).isEmpty()) {
            this.playerModify(event.getPlayer(), block, (Cancellable)event);
        }
    }

    @EventHandler
    public void onBlockBurn(BlockBurnEvent event) {
        this.blockModify(event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        if (!JustPlots.isPlotWorld(event.getBlock().getWorld())) {
            return;
        }
        Plot fromPlot = JustPlots.getPlotAt(event.getBlock().getLocation());
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            Plot toPlot = JustPlots.getPlotAt(((Block)iterator.next()).getLocation());
            if (fromPlot == toPlot) continue;
            iterator.remove();
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!JustPlots.isPlotWorld(event.getLocation().getWorld())) {
            return;
        }
        Plot fromPlot = JustPlots.getPlotAt(PaperUtil.getOrigin(event.getEntity()));
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            Plot toPlot = JustPlots.getPlotAt(((Block)iterator.next()).getLocation());
            if (fromPlot == toPlot) continue;
            iterator.remove();
        }
    }

    @EventHandler
    public void onBlockFade(BlockFadeEvent event) {
        this.blockModify(event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBlockFertilize(BlockFertilizeEvent event) {
        if (!JustPlots.isPlotWorld(event.getBlock().getWorld())) {
            return;
        }
        Plot fromPlot = JustPlots.getPlotAt(event.getBlock().getLocation());
        Iterator iterator = event.getBlocks().iterator();
        while (iterator.hasNext()) {
            Plot toPlot = JustPlots.getPlotAt(((BlockState)iterator.next()).getLocation());
            if (fromPlot == toPlot && (event.getPlayer() == null || event.getPlayer().hasPermission("justplots.edit.other") || toPlot != null && toPlot.isAdded(event.getPlayer().getUniqueId()))) continue;
            iterator.remove();
        }
    }

    @EventHandler
    public void onStructureGrow(StructureGrowEvent event) {
        if (!JustPlots.isPlotWorld(event.getLocation().getWorld())) {
            return;
        }
        Plot fromPlot = JustPlots.getPlotAt(event.getLocation());
        Iterator iterator = event.getBlocks().iterator();
        while (iterator.hasNext()) {
            Plot toPlot = JustPlots.getPlotAt(((BlockState)iterator.next()).getLocation());
            if (fromPlot == toPlot && (event.getPlayer() == null || event.getPlayer().hasPermission("justplots.edit.other") || toPlot != null && toPlot.isAdded(event.getPlayer().getUniqueId()))) continue;
            iterator.remove();
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        this.blockModify(event.getBlock(), event.getToBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBlockGrow(BlockGrowEvent event) {
        this.blockModify(event.getBlock(), event.getNewState().getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.getIgnitingBlock() != null) {
            this.blockModify(event.getIgnitingBlock(), event.getBlock(), (Cancellable)event);
        }
        if (event.getIgnitingEntity() instanceof Player) {
            this.playerModify((Player)event.getIgnitingEntity(), event.getBlock(), (Cancellable)event);
        } else if (event.getIgnitingEntity() != null) {
            this.entityModify(event.getIgnitingEntity(), event.getBlock(), (Cancellable)event);
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            this.blockModify(event.getBlock(), block, (Cancellable)event);
            this.blockModify(event.getBlock(), block.getRelative(event.getDirection()), (Cancellable)event);
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            this.blockModify(event.getBlock(), block, (Cancellable)event);
        }
    }

    @EventHandler
    public void onBlockSpread(BlockSpreadEvent event) {
        this.blockModify(event.getSource(), event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent event) {
        this.blockModify(event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onSpongeAbsorb(SpongeAbsorbEvent event) {
        if (!JustPlots.isPlotWorld(event.getBlock().getWorld())) {
            return;
        }
        Plot fromPlot = JustPlots.getPlotAt(event.getBlock().getLocation());
        Iterator iterator = event.getBlocks().iterator();
        while (iterator.hasNext()) {
            Plot toPlot = JustPlots.getPlotAt(((BlockState)iterator.next()).getLocation());
            if (fromPlot == toPlot) continue;
            iterator.remove();
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity damager = this.getSource(event.getDamager());
        if (damager instanceof Player && !(event.getEntity() instanceof Player)) {
            this.playerModify((Player)damager, event.getEntity(), (Cancellable)event);
            if (event.isCancelled() && event.getDamager() instanceof Projectile) {
                event.setDamage(0.0);
                event.getDamager().remove();
            }
        }
    }

    @EventHandler
    public void onVehicleDamage(VehicleDamageEvent event) {
        Entity attacker = this.getSource(event.getAttacker());
        if (attacker instanceof Player) {
            this.playerModify((Player)attacker, (Entity)event.getVehicle(), (Cancellable)event);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        this.playerModify(event.getPlayer(), event.getRightClicked(), (Cancellable)event);
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        this.playerModify(event.getPlayer(), event.getRightClicked(), (Cancellable)event);
    }

    @EventHandler
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        Entity remover = this.getSource(event.getRemover());
        if (remover instanceof Player) {
            this.playerModify((Player)remover, (Entity)event.getEntity(), (Cancellable)event);
        }
    }

    @EventHandler
    public void onBlockDispense(BlockDispenseEvent event) {
        Block facing = event.getBlock().getRelative(((Directional)event.getBlock().getBlockData()).getFacing());
        this.blockModify(event.getBlock(), facing, (Cancellable)event);
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getCaught() != null) {
            this.playerModify(event.getPlayer(), event.getCaught(), (Cancellable)event);
        }
    }

    @EventHandler
    public void onPotionSplash(PotionSplashEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            this.playerModify((Player)event.getEntity().getShooter(), (Entity)event.getEntity(), (Cancellable)event);
        }
    }

    @EventHandler
    public void onLingeringPotionSplash(LingeringPotionSplashEvent event) {
        if (event.getEntity().getShooter() instanceof Player) {
            this.playerModify((Player)event.getEntity().getShooter(), (Entity)event.getEntity(), (Cancellable)event);
        }
    }

    @EventHandler
    public void onEggHit(ProjectileHitEvent event) {
        if (event.getEntity() instanceof Egg) {
            if (!JustPlots.isPlotWorld(event.getEntity().getWorld())) {
                return;
            }
            this.lastEggThrower = event.getEntity().getShooter();
        }
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent event) {
        PaperUtil.getOrigin(event.getEntity());
    }

    @EventHandler
    public void onEggSpawnChicken(CreatureSpawnEvent event) {
        if (event.getEntity() instanceof Chicken && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.EGG && this.lastEggThrower != null) {
            if (!JustPlots.isPlotWorld(event.getEntity().getWorld())) {
                return;
            }
            if (this.lastEggThrower instanceof Player) {
                Player player = (Player)this.lastEggThrower;
                Plot plot = JustPlots.getPlotAt((Entity)event.getEntity());
                if (!(plot != null && plot.isAdded((OfflinePlayer)player) || player.hasPermission("justplots.edit.other"))) {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, new ComponentBuilder("You cannot build here").color(ChatColor.RED).create());
                    event.getEntity().remove();
                    event.setCancelled(true);
                }
            } else if (this.lastEggThrower instanceof BlockProjectileSource) {
                Plot from = JustPlots.getPlotAt(((BlockProjectileSource)this.lastEggThrower).getBlock().getLocation());
                Plot to = JustPlots.getPlotAt((Entity)event.getEntity());
                if (to != from) {
                    event.getEntity().remove();
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        this.entityModify(event.getEntity(), event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onEntityBlockForm(EntityBlockFormEvent event) {
        this.entityModify(event.getEntity(), event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBucketFill(PlayerBucketFillEvent event) {
        this.playerModify(event.getPlayer(), event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        this.playerModify(event.getPlayer(), event.getBlock(), (Cancellable)event);
    }

    @EventHandler
    public void onEntityTeleport(EntityTeleportEvent event) {
        if (event.getTo() != null) {
            this.entityModify(event.getEntity(), event.getTo(), (Cancellable)event);
        }
    }

    private Entity getSource(Entity entity) {
        if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Entity) {
            return this.getSource((Entity)((Projectile)entity).getShooter());
        }
        return entity;
    }
}

