/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.listeners;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import com.destroystokyo.paper.event.entity.SlimePathfindEvent;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PaperListener
implements Listener {
    public PaperListener(JustPlots plots) {
        plots.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plots);
    }

    private Plot getPlotOrigin(Entity entity) {
        Location origin = entity.getOrigin();
        if (origin != null) {
            return JustPlots.getPlotAt(origin);
        }
        return JustPlots.getPlotAt(entity);
    }

    private double squareDistance(Location loc1, Location loc2) {
        return Math.max(Math.abs(loc1.getX() - loc2.getX()), Math.abs(loc1.getZ() - loc2.getZ()));
    }

    @EventHandler
    public void onEntityPathfind(EntityPathfindEvent event) {
        if (!JustPlots.isPlotWorld(event.getEntity().getWorld())) {
            return;
        }
        Plot from = this.getPlotOrigin(event.getEntity());
        Plot to = JustPlots.getPlotAt(event.getLoc());
        if (to != from) {
            if (from != null && from != JustPlots.getPlotAt(event.getEntity())) {
                Location middle = from.getMiddle();
                double entityDistance = this.squareDistance(event.getEntity().getLocation(), middle);
                double locDistance = this.squareDistance(event.getLoc(), middle);
                if (locDistance <= entityDistance) {
                    return;
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPathfind(SlimePathfindEvent event) {
        if (!JustPlots.isPlotWorld(event.getEntity().getWorld())) {
            return;
        }
        Block target = event.getEntity().getTargetBlock(4);
        if (target == null) {
            return;
        }
        Plot from = this.getPlotOrigin((Entity)event.getEntity());
        Plot to = JustPlots.getPlotAt(target.getLocation());
        if (to != from) {
            if (from != null && from != JustPlots.getPlotAt((Entity)event.getEntity())) {
                Location middle = from.getMiddle();
                double entityDistance = this.squareDistance(event.getEntity().getLocation(), middle);
                double locDistance = this.squareDistance(target.getLocation(), middle);
                if (locDistance <= entityDistance) {
                    return;
                }
            }
            Location location = event.getEntity().getLocation();
            location.setYaw((float)(Math.random() * 360.0));
            event.getEntity().teleport(location);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBeaconEffect(BeaconEffectEvent event) {
        Location beaconLocation = event.getBlock().getLocation();
        Player player = event.getPlayer();
        Plot beaconPlot = JustPlots.getPlotAt(beaconLocation);
        Plot playerPlot = JustPlots.getPlotAt((Entity)player);
        if (beaconPlot != null && beaconPlot != playerPlot) {
            event.setCancelled(true);
        }
    }
}

