/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.listeners;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;
import java.util.UUID;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import net.justminecraft.plots.commands.WeanywhereCommand;
import net.justminecraft.plots.events.PlotDeletedEvent;
import net.justminecraft.plots.events.PlotEnterEvent;
import net.justminecraft.plots.events.PlotPlayerAddEvent;
import net.justminecraft.plots.events.PlotPlayerRemoveEvent;
import net.justminecraft.plots.util.JustPlotsRegionMask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class WorldEditListener
implements Listener {
    private WorldEditPlugin worldEditPlugin = null;

    public WorldEditListener(JustPlots plots) {
        for (Plugin plugin : plots.getServer().getPluginManager().getPlugins()) {
            if (!(plugin instanceof WorldEditPlugin)) continue;
            this.worldEditPlugin = (WorldEditPlugin)plugin;
        }
        if (this.worldEditPlugin != null) {
            WeanywhereCommand.setWorldEditListener(this);
            plots.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plots);
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.setup(player);
            }
        }
    }

    public void setup(Player player) {
        if (JustPlots.isPlotWorld(player.getWorld())) {
            Plot plot = JustPlots.getPlotAt((Entity)player);
            if (WeanywhereCommand.isWeanywhere(player)) {
                this.removeMask(player);
            } else if (plot != null && plot.isAdded((OfflinePlayer)player)) {
                this.setMask(player, plot);
            } else {
                this.setMask(player, null);
            }
        }
    }

    @EventHandler
    public void onJoinEvent(PlayerJoinEvent e) {
        this.setup(e.getPlayer());
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        if (JustPlots.isPlotWorld(e.getFrom()) && !JustPlots.isPlotWorld(e.getPlayer().getWorld()) && this.isJustPlotsMask(e.getPlayer())) {
            this.removeMask(e.getPlayer());
        } else {
            this.setup(e.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlotEnter(PlotEnterEvent e) {
        if (!WeanywhereCommand.isWeanywhere(e.getPlayer()) && e.getPlot().isAdded((OfflinePlayer)e.getPlayer())) {
            this.setMask(e.getPlayer(), e.getPlot());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlotPlayerAdded(PlotPlayerAddEvent e) {
        if (e.getPlayer() != null && JustPlots.getPlotAt((Entity)e.getPlayer()) == e.getPlot()) {
            this.setMask(e.getPlayer(), e.getPlot());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlotPlayerRemoved(PlotPlayerRemoveEvent e) {
        if (e.getPlayer() != null && this.getMaskPlot(e.getPlayer()) == e.getPlot()) {
            Bukkit.getScheduler().runTask((Plugin)JustPlots.getPlugin(), () -> this.setup(e.getPlayer()));
        }
    }

    @EventHandler
    public void onPlotPlayerRemoved(PlotDeletedEvent e) {
        Player player;
        for (UUID added : e.getPlot().getAdded()) {
            player = Bukkit.getPlayer((UUID)added);
            if (player == null || this.getMaskPlot(player) != e.getPlot()) continue;
            this.setup(player);
        }
        player = Bukkit.getPlayer((UUID)e.getPlot().getOwner());
        if (player != null && this.getMaskPlot(player) == e.getPlot()) {
            this.setup(player);
        }
    }

    private boolean isJustPlotsMask(Player player) {
        return this.worldEditPlugin.getSession(player).getMask() instanceof JustPlotsRegionMask;
    }

    private Plot getMaskPlot(Player player) {
        Mask mask = this.worldEditPlugin.getSession(player).getMask();
        return mask instanceof JustPlotsRegionMask ? ((JustPlotsRegionMask)mask).getPlot() : null;
    }

    private void setMask(Player player, Plot plot) {
        Location top;
        Location bottom;
        if (plot != null) {
            bottom = plot.getBottom();
            top = plot.getTop();
        } else {
            bottom = top = new Location(player.getWorld(), 0.0, -2.147483648E9, 0.0);
        }
        LocalSession localSession = this.worldEditPlugin.getSession(player);
        World world = localSession.getSelectionWorld();
        BlockVector3 pos1 = BlockVector3.at((int)bottom.getBlockX(), (int)bottom.getBlockY(), (int)bottom.getBlockZ());
        BlockVector3 pos2 = BlockVector3.at((int)top.getBlockX(), (int)top.getBlockY(), (int)top.getBlockZ());
        CuboidRegion cuboidRegion = new CuboidRegion(world, pos1, pos2);
        JustPlotsRegionMask regionMask = new JustPlotsRegionMask(cuboidRegion, plot);
        localSession.setMask((Mask)regionMask);
    }

    private void removeMask(Player player) {
        LocalSession localSession = this.worldEditPlugin.getSession(player);
        localSession.setMask(null);
    }
}

