/*
 * Decompiled with CFR 0.152.
 */
package net.justminecraft.plots.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.UUID;
import net.justminecraft.plots.JustPlots;
import net.justminecraft.plots.Plot;
import org.bukkit.configuration.ConfigurationSection;

public class PlotLoader
implements Runnable {
    private final JustPlots plots;

    public PlotLoader(JustPlots plots) {
        this.plots = plots;
        this.loadPlotWorlds();
        this.run();
    }

    private void loadPlotWorlds() {
        ConfigurationSection worldsSection = this.plots.getConfig().getConfigurationSection("worlds");
        if (worldsSection != null) {
            for (String name : worldsSection.getKeys(false)) {
                ConfigurationSection config = worldsSection.getConfigurationSection(name);
                JustPlots.getPlotWorld(name).load(config);
            }
        }
    }

    private void loadPlots() {
        int counter = 0;
        try (PreparedStatement statement = JustPlots.getDatabase().prepareStatement("SELECT * FROM justplots_plots");){
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                String world = results.getString("world");
                int x = results.getInt("x");
                int z = results.getInt("z");
                String owner = results.getString("owner");
                Timestamp creation = results.getTimestamp("creation");
                try {
                    new Plot(world, x, z, UUID.fromString(owner), creation.getTime());
                }
                catch (Exception e) {
                    this.plots.getLogger().warning("Could not load plot " + world + ";" + x + ";" + z);
                    e.printStackTrace();
                }
                if (++counter % 10000 != 0) continue;
                this.plots.getLogger().info("Loading plots... (" + counter + ")");
            }
        }
        catch (SQLException e) {
            this.plots.getLogger().severe("FAILED TO LOAD PLOTS");
            e.printStackTrace();
            return;
        }
    }

    private void loadAdded() {
        int counter = 0;
        try (PreparedStatement statement = JustPlots.getDatabase().prepareStatement("SELECT * FROM justplots_added");){
            ResultSet results = statement.executeQuery();
            while (results.next()) {
                String world = results.getString("world");
                int x = results.getInt("x");
                int z = results.getInt("z");
                String owner = results.getString("uuid");
                try {
                    Plot plot = JustPlots.getPlot(world, x, z);
                    plot.getAdded().add(UUID.fromString(owner));
                }
                catch (Exception e) {
                    this.plots.getLogger().warning("Could not load added player for plot " + world + ";" + x + ";" + z);
                    e.printStackTrace();
                }
                if (++counter % 10000 != 0) continue;
                this.plots.getLogger().info("Loading added players... (" + counter + ")");
            }
        }
        catch (SQLException e) {
            this.plots.getLogger().severe("FAILED TO LOAD ADDED PLAYERS");
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void run() {
        long timer = System.currentTimeMillis();
        this.plots.getLogger().info("Loading plots...");
        this.loadPlots();
        this.loadAdded();
        this.plots.getLogger().info("Loaded plots (took " + (System.currentTimeMillis() - timer) + "ms)");
    }
}

