/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.jgram;

import com.sun.gluegen.jgram.JavaLexer;
import com.sun.gluegen.jgram.JavaParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Set;

class Test {
    static boolean showTree = false;

    Test() {
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                System.err.println("Parsing...");
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-showtree")) {
                        showTree = true;
                        continue;
                    }
                    Test.doFile(new File(args[i]));
                }
            } else {
                System.err.println("Usage: java com.sun.gluegen.jgram.Test [-showtree] <directory or file name>");
            }
        }
        catch (Exception e) {
            System.err.println("exception: " + e);
            e.printStackTrace(System.err);
        }
    }

    public static void doFile(File f) throws Exception {
        if (f.isDirectory()) {
            String[] files = f.list();
            for (int i = 0; i < files.length; ++i) {
                Test.doFile(new File(f, files[i]));
            }
        } else if (f.getName().length() > 5 && f.getName().substring(f.getName().length() - 5).equals(".java")) {
            System.err.println("   " + f.getAbsolutePath());
            Test.parseFile(f.getName(), new BufferedReader(new FileReader(f)));
        }
    }

    public static void parseFile(String f, Reader r) throws Exception {
        try {
            JavaLexer lexer = new JavaLexer(r);
            lexer.setFilename(f);
            JavaParser parser = new JavaParser(lexer);
            parser.setFilename(f);
            parser.compilationUnit();
            Set set = parser.getParsedEnumNames();
            System.out.println("Enums");
            for (String s : set) {
                System.out.println(s);
            }
            System.out.println("Functions");
            set = parser.getParsedFunctionNames();
            for (String s : set) {
                System.out.println(s);
            }
        }
        catch (Exception e) {
            System.err.println("parser exception: " + e);
            e.printStackTrace();
        }
    }
}

