/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.ftod.zcube.zdd.ZDD;
import net.ftod.zcube.zdd.ZDDCacheN;
import net.ftod.zcube.zdd.ZDDCacheO;
import net.ftod.zcube.zdd.ZDDCacheP;
import net.ftod.zcube.zdd.ZDDTreeCross;
import net.ftod.zcube.zdd.ZDDTreeL;
import net.ftod.zcube.zdd.ZDDTreePrefix;
import net.ftod.zcube.zdd.ZDDTreeSum;

public abstract class ZDDTree {
    public static final ZDDTree BOT = new ZDDTree(){

        @Override
        protected ZDDTreeL treeL(long h) {
            return ZDDTreeL.bot();
        }

        public String toString() {
            return "bot";
        }
    };
    public static final ZDDTree TOP = new ZDDTree(){

        @Override
        protected ZDDTreeL treeL(long h) {
            return ZDDTreeL.top();
        }

        public String toString() {
            return "top";
        }
    };

    public static ZDDTree prefix(String p, ZDDTree t) {
        return new ZDDTreePrefix(p, t);
    }

    public static ZDDTree prefix(ZDDTree t, String ... p) {
        return ZDDTree.prefix(Arrays.asList(p), t);
    }

    public static ZDDTree prefix(Iterable<String> p, ZDDTree t) {
        return ZDDTree.prefix(p.iterator(), t);
    }

    public static ZDDTree prefix(Iterator<String> p, ZDDTree t) {
        if (p.hasNext()) {
            return new ZDDTreePrefix(p.next(), ZDDTree.prefix(p, t));
        }
        return t;
    }

    public static ZDDTree path(String ... p) {
        return ZDDTree.path(Arrays.asList(p));
    }

    public static ZDDTree path(Iterable<String> p) {
        return ZDDTree.path(p.iterator());
    }

    public static ZDDTree path(Iterator<String> p) {
        return ZDDTree.prefix(p, TOP);
    }

    public static ZDDTree cross(ZDDTree ... ts) {
        return new ZDDTreeCross(ts);
    }

    public static ZDDTree cross(Collection<ZDDTree> ts) {
        return ZDDTree.cross(ZDDTree.array(ts));
    }

    public static ZDDTree sum(ZDDTree ... ts) {
        return new ZDDTreeSum(ts);
    }

    public static ZDDTree sum(Collection<ZDDTree> ts) {
        return ZDDTree.sum(ZDDTree.array(ts));
    }

    public static ZDDTreeL treeL(ZDDTree t) {
        return t.treeL(1L);
    }

    protected static final ZDDTreeL[] treeL(long h, ZDDTree[] ts) {
        int n = ts.length;
        ZDDTreeL[] tsl = new ZDDTreeL[n];
        int i = 0;
        while (i < n) {
            tsl[i] = ts[i].treeL(h);
            ++i;
        }
        return tsl;
    }

    protected abstract ZDDTreeL treeL(long var1);

    public static ZDD trees(ZDDTree t) {
        return ZDDTree.trees(t, new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO());
    }

    static ZDD trees(ZDDTree t, ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni) {
        return ZDDTreeL.trees(ZDDTree.treeL(t), _nod, _equ, _cru, _uni);
    }

    public static ZDD unionTrees(ZDDTree ... ts) {
        return ZDDTree.unionTrees(ts, new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO());
    }

    static ZDD unionTrees(ZDDTree[] ts, ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni) {
        int n = ts.length;
        ZDD[] zs = new ZDD[n];
        int i = 0;
        while (i < n) {
            zs[i] = ZDDTree.trees(ts[i], _nod, _equ, _cru, _uni);
            ++i;
        }
        return ZDD.union(_nod, _equ, _uni, zs);
    }

    public static ZDD subtrees(ZDDTree t) {
        return ZDDTree.subtrees(t, new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO());
    }

    static ZDD subtrees(ZDDTree t, ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni) {
        return ZDDTreeL.subtrees(ZDDTree.treeL(t), _nod, _equ, _cru, _uni);
    }

    public static ZDD subtrees(ZDD z, ZDDTree t) {
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        ZDDCacheO _int = new ZDDCacheO();
        return ZDD.intersection(_nod, _equ, _int, z, ZDDTree.subtrees(t, _nod, _equ, _cru, _uni));
    }

    private static ZDDTree[] array(Collection<ZDDTree> c) {
        ZDDTree[] a = new ZDDTree[c.size()];
        c.toArray(a);
        return a;
    }
}

