/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import net.ftod.zcube.zdd.ZDD;
import net.ftod.zcube.zdd.ZDDCacheN;
import net.ftod.zcube.zdd.ZDDCacheO;
import net.ftod.zcube.zdd.ZDDCacheP;
import net.ftod.zcube.zdd.ZDDTerm;
import net.ftod.zcube.zdd.ZDDTree;

public final class ZDDNumber {
    private static final int PROCESSOR_SPREAD = 8;
    public final ZDD digit;
    public final ZDDNumber number;
    public static final ZDDNumber ZERO = new ZDDNumber(null, null);

    private ZDDNumber(ZDD digit, ZDDNumber number) {
        this.digit = digit;
        this.number = number;
    }

    private static ZDDNumber number(ZDD digit, ZDDNumber number) {
        if (digit == ZDD.BOT && number == ZERO) {
            return ZERO;
        }
        return new ZDDNumber(digit, number);
    }

    static ZDDNumber shift(ZDDNumber n) {
        return ZDDNumber.number(ZDD.BOT, n);
    }

    public static ZDDNumber binary(long l, ZDD zdd) {
        return l == 0L ? ZERO : ZDDNumber.number(l % 2L == 0L ? ZDD.BOT : zdd, ZDDNumber.binary(l >> 1, zdd));
    }

    public static long binary(ZDDNumber zddn, ZDD zdd) {
        return ZDDNumber.binary(new ZDDCacheP(), new ZDDCacheP(), zddn, zdd);
    }

    static long binary(ZDDCacheP eq, ZDDCacheP in, ZDDNumber zddn, ZDD zdd) {
        return zddn == ZERO ? 0L : (ZDD.included(eq, in, zdd, zddn.digit) ? 1L : 0L) + (ZDDNumber.binary(eq, in, zddn.number, zdd) << 1);
    }

    public static ZDDNumber binaryAdd(ZDDNumber zddn1, ZDDNumber zddn2) {
        return ZDDNumber.binaryAdd(new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO(), new ZDDCacheO(), zddn1, zddn2);
    }

    static ZDDNumber binaryAdd(ZDDCacheN nod, ZDDCacheP eq, ZDDCacheO in, ZDDCacheO un, ZDDCacheO di, ZDDNumber zddn1, ZDDNumber zddn2) {
        ZDDNumber zddnc = ZDDNumber.intersection(nod, eq, in, zddn1, zddn2);
        ZDDNumber zddns = ZDDNumber.difference(nod, eq, di, ZDDNumber.union(nod, eq, un, zddn1, zddn2), zddnc);
        if (zddnc == ZERO) {
            return zddns;
        }
        if (zddns == ZERO) {
            return new ZDDNumber(ZDD.BOT, zddnc);
        }
        return ZDDNumber.number(zddns.digit, ZDDNumber.binaryAdd(nod, eq, in, un, di, zddns.number, zddnc));
    }

    public static ZDDNumber negabinary(long l, ZDD zdd) {
        long l1;
        ZDD digit;
        if (l == 0L) {
            return ZERO;
        }
        long q = l / -2L;
        long r = l + 2L * q;
        if (r > 0L) {
            digit = zdd;
            l1 = q;
        } else if (r < 0L) {
            digit = zdd;
            l1 = q + 1L;
        } else {
            digit = ZDD.BOT;
            l1 = q;
        }
        return ZDDNumber.number(digit, ZDDNumber.negabinary(l1, zdd));
    }

    public static long negabinary(ZDDNumber zddn, ZDD zdd) {
        return ZDDNumber.negabinary(new ZDDCacheP(), new ZDDCacheP(), zddn, zdd);
    }

    static long negabinary(ZDDCacheP eq, ZDDCacheP in, ZDDNumber zddn, ZDD zdd) {
        if (zddn == ZERO) {
            return 0L;
        }
        return (ZDD.included(eq, in, zdd, zddn.digit) ? 1L : 0L) + ZDDNumber.negabinary(eq, in, zddn.number, zdd) * -2L;
    }

    public static ZDDNumber negabinaryAdd(ZDDNumber zddn1, ZDDNumber zddn2) {
        return ZDDNumber.negabinaryAdd(new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO(), new ZDDCacheO(), zddn1, zddn2);
    }

    public static ZDDNumber negabinaryAdd(Iterable<ZDDNumber> i) {
        return ZDDNumber.negabinaryAdd(i.iterator());
    }

    public static ZDDNumber negabinaryAdd(Iterator<ZDDNumber> i) {
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _int = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        ZDDCacheO _dif = new ZDDCacheO();
        ZDDNumber zn = ZERO;
        while (i.hasNext()) {
            zn = ZDDNumber.negabinaryAdd(_nod, _equ, _int, _uni, _dif, zn, i.next());
        }
        return zn;
    }

    static ZDDNumber negabinaryAdd(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _int, ZDDCacheO _uni, ZDDCacheO _dif, ZDDNumber zddn1, ZDDNumber zddn2) {
        ZDDNumber zddnc = ZDDNumber.intersection(_nod, _equ, _int, zddn1, zddn2);
        ZDDNumber zddns = ZDDNumber.difference(_nod, _equ, _dif, ZDDNumber.union(_nod, _equ, _uni, zddn1, zddn2), zddnc);
        if (zddnc == ZERO) {
            return zddns;
        }
        return ZDDNumber.negabinarySub(_nod, _equ, _int, _uni, _dif, zddns, ZDDNumber.shift(zddnc));
    }

    public static ZDDNumber negabinarySub(ZDDNumber zddn1, ZDDNumber zddn2) {
        return ZDDNumber.negabinarySub(new ZDDCacheN(), new ZDDCacheP(), new ZDDCacheO(), new ZDDCacheO(), new ZDDCacheO(), zddn1, zddn2);
    }

    static ZDDNumber negabinarySub(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _int, ZDDCacheO _uni, ZDDCacheO _dif, ZDDNumber zddn1, ZDDNumber zddn2) {
        ZDDNumber zddnb = ZDDNumber.difference(_nod, _equ, _dif, zddn2, zddn1);
        ZDDNumber zddnd = ZDDNumber.union(_nod, _equ, _uni, ZDDNumber.difference(_nod, _equ, _dif, zddn1, zddn2), zddnb);
        if (zddnb == ZERO) {
            return zddnd;
        }
        return ZDDNumber.negabinaryAdd(_nod, _equ, _int, _uni, _dif, zddnd, ZDDNumber.shift(zddnb));
    }

    private static ZDDNumber intersection(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _int, ZDDNumber zddn1, ZDDNumber zddn2) {
        if (zddn1 == ZERO) {
            return ZERO;
        }
        if (zddn2 == ZERO) {
            return ZERO;
        }
        return ZDDNumber.number(ZDD.intersection(_nod, _equ, _int, zddn1.digit, zddn2.digit), ZDDNumber.intersection(_nod, _equ, _int, zddn1.number, zddn2.number));
    }

    private static ZDDNumber union(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _uni, ZDDNumber zddn1, ZDDNumber zddn2) {
        if (zddn1 == ZERO) {
            return zddn2;
        }
        if (zddn2 == ZERO) {
            return zddn1;
        }
        return ZDDNumber.number(ZDD.union(_nod, _equ, _uni, zddn1.digit, zddn2.digit), ZDDNumber.union(_nod, _equ, _uni, zddn1.number, zddn2.number));
    }

    private static ZDDNumber difference(ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _dif, ZDDNumber zddn1, ZDDNumber zddn2) {
        if (zddn1 == ZERO) {
            return ZERO;
        }
        if (zddn2 == ZERO) {
            return zddn1;
        }
        return ZDDNumber.number(ZDD.difference(_nod, _equ, _dif, zddn1.digit, zddn2.digit), ZDDNumber.difference(_nod, _equ, _dif, zddn1.number, zddn2.number));
    }

    public static ZDDNumber addSubtrees(ZDDTerm zt, ZDDNumber zn) {
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        ZDDCacheO _int = new ZDDCacheO();
        ZDDCacheO _dif = new ZDDCacheO();
        return ZDDNumber.addSubtrees(zt, zn, _nod, _equ, _cru, _uni, _int, _dif);
    }

    static ZDDNumber addSubtrees(ZDDTerm zt, ZDDNumber zn, ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni, ZDDCacheO _int, ZDDCacheO _dif) {
        return ZDDNumber.negabinaryAdd(_nod, _equ, _int, _uni, _dif, zt.subtrees(_nod, _equ, _cru, _uni), zn);
    }

    public static ZDDNumber addSubtrees(ZDD filter, ZDDTerm zt, ZDDNumber zn) {
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        ZDDCacheO _int = new ZDDCacheO();
        ZDDCacheO _dif = new ZDDCacheO();
        return ZDDNumber.addSubtrees(filter, zt, zn, _nod, _equ, _cru, _uni, _int, _dif);
    }

    static ZDDNumber addSubtrees(ZDD filter, ZDDTerm zt, ZDDNumber zn, ZDDCacheN _nod, ZDDCacheP _equ, ZDDCacheO _cru, ZDDCacheO _uni, ZDDCacheO _int, ZDDCacheO _dif) {
        return ZDDNumber.negabinaryAdd(_nod, _equ, _int, _uni, _dif, zt.subtrees(_nod, _equ, _cru, _uni, _int, filter), zn);
    }

    public static ZDDNumber addSubtrees(ZDDTerm zt, ZDD filter, ZDDNumber zn) {
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        ZDDCacheO _int = new ZDDCacheO();
        ZDDCacheO _dif = new ZDDCacheO();
        return ZDDNumber.addSubtrees(filter, zt, zn, _nod, _equ, _cru, _uni, _int, _dif);
    }

    public static long[] sumGroupBy(ZDDTree[] ts, Iterable<ZDDTerm> i) {
        int n = ts.length;
        ZDD[] zs = new ZDD[n];
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        int j = 0;
        while (j < n) {
            zs[j] = ZDDTree.trees(ts[j], _nod, _equ, _cru, _uni);
            ++j;
        }
        ZDD u = ZDD.union(_nod, _equ, _uni, zs);
        ZDDNumber zn = ZDDNumber.sumSubtrees(u, i);
        long[] ls = new long[n];
        int j2 = 0;
        while (j2 < n) {
            ls[j2] = ZDDNumber.negabinary(zn, zs[j2]);
            ++j2;
        }
        return ls;
    }

    public static long[] pSumGroupBy(ZDDTree[] ts, Iterable<ZDDTerm> i) {
        int n = ts.length;
        ZDD[] zs = new ZDD[n];
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        int j = 0;
        while (j < n) {
            zs[j] = ZDDTree.trees(ts[j], _nod, _equ, _cru, _uni);
            ++j;
        }
        ZDD u = ZDD.union(_nod, _equ, _uni, zs);
        ZDDNumber zn = ZDDNumber.pSumSubtrees(u, i);
        long[] ls = new long[n];
        int j2 = 0;
        while (j2 < n) {
            ls[j2] = ZDDNumber.negabinary(zn, zs[j2]);
            ++j2;
        }
        return ls;
    }

    public static ZDDNumber pSumSubtrees(Iterable<ZDDTerm> i) {
        return ZDDNumber.pSumSubtrees(i.iterator());
    }

    public static ZDDNumber pSumSubtrees(Iterator<ZDDTerm> i) {
        int processors = Runtime.getRuntime().availableProcessors();
        int sums = 8 * processors;
        ExecutorService threads = Executors.newFixedThreadPool(processors);
        ArrayBlockingQueue<ZDDNumber> zns = new ArrayBlockingQueue<ZDDNumber>(sums);
        int j = 0;
        while (j < sums) {
            zns.offer(ZERO);
            ++j;
        }
        while (i.hasNext()) {
            threads.submit(ZDDNumber.sumTask(zns, i.next()));
        }
        ZDDNumber.awaitTermination(threads);
        return ZDDNumber.pSum(processors, zns);
    }

    private static Runnable sumTask(final BlockingQueue<ZDDNumber> zns, final ZDDTerm zt) {
        ZDDNumber zn;
        try {
            zn = zns.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    zns.put(ZDDNumber.addSubtrees(zt, zn));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static ZDDNumber pSumSubtrees(ZDD filter, Iterable<ZDDTerm> i) {
        return ZDDNumber.pSumSubtrees(filter, i.iterator());
    }

    public static ZDDNumber pSumSubtrees(ZDD filter, Iterator<ZDDTerm> i) {
        int processors = Runtime.getRuntime().availableProcessors();
        int sums = 8 * processors;
        ExecutorService threads = Executors.newFixedThreadPool(processors);
        ArrayBlockingQueue<ZDDNumber> zns = new ArrayBlockingQueue<ZDDNumber>(sums);
        int j = 0;
        while (j < sums) {
            zns.offer(ZERO);
            ++j;
        }
        while (i.hasNext()) {
            threads.submit(ZDDNumber.sumTask(filter, zns, i.next()));
        }
        ZDDNumber.awaitTermination(threads);
        return ZDDNumber.pSum(processors, zns);
    }

    public static ZDDNumber pSum(Collection<ZDDNumber> zns) {
        return ZDDNumber.pSum(Runtime.getRuntime().availableProcessors(), zns);
    }

    private static ZDDNumber pSum(int processors, Collection<ZDDNumber> zns) {
        ZDDNumber[] zna = new ZDDNumber[zns.size()];
        zns.toArray(zna);
        return ZDDNumber.pSum(processors, zna);
    }

    private static ZDDNumber pSum(int processors, ZDDNumber[] zna) {
        ForkJoinPool forkJoinPool = new ForkJoinPool(processors);
        try {
            ZDDNumber zDDNumber = forkJoinPool.invoke(ZDDNumber.recursiveSumTask(zna, 0, zna.length));
            return zDDNumber;
        }
        finally {
            ZDDNumber.awaitTermination(forkJoinPool);
        }
    }

    private static RecursiveTask<ZDDNumber> recursiveSumTask(final ZDDNumber[] zns, final int begin, final int end) {
        return new RecursiveTask<ZDDNumber>(){
            private static final long serialVersionUID = 9099502138482957070L;

            @Override
            protected ZDDNumber compute() {
                int length = end - begin;
                if (length > 2) {
                    int middle = begin + (length >> 1);
                    RecursiveTask t1 = ZDDNumber.recursiveSumTask(zns, begin, middle);
                    RecursiveTask t2 = ZDDNumber.recursiveSumTask(zns, middle, end);
                    2.invokeAll(t1, t2);
                    return ZDDNumber.negabinaryAdd((ZDDNumber)t1.join(), (ZDDNumber)t2.join());
                }
                if (length > 1) {
                    return ZDDNumber.negabinaryAdd(zns[begin], zns[begin + 1]);
                }
                if (length > 0) {
                    return zns[begin];
                }
                return ZERO;
            }
        };
    }

    private static Runnable sumTask(final ZDD filter, final BlockingQueue<ZDDNumber> zns, final ZDDTerm zt) {
        ZDDNumber zn;
        try {
            zn = zns.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new Runnable(){

            @Override
            public void run() {
                try {
                    zns.put(ZDDNumber.addSubtrees(zt, filter, zn));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static void awaitTermination(ExecutorService es) {
        es.shutdown();
        try {
            es.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static ZDDNumber sumSubtrees(Iterable<ZDDTerm> i) {
        return ZDDNumber.sumSubtrees(i.iterator());
    }

    public static ZDDNumber sumSubtrees(Iterator<ZDDTerm> i) {
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        ZDDCacheO _int = new ZDDCacheO();
        ZDDCacheO _dif = new ZDDCacheO();
        ZDDNumber zn = ZERO;
        while (i.hasNext()) {
            zn = ZDDNumber.addSubtrees(i.next(), zn, _nod, _equ, _cru, _uni, _int, _dif);
        }
        return zn;
    }

    public static ZDDNumber sumSubtrees(ZDD filter, Iterable<ZDDTerm> i) {
        return ZDDNumber.sumSubtrees(filter, i.iterator());
    }

    public static ZDDNumber sumSubtrees(ZDD filter, Iterator<ZDDTerm> i) {
        ZDDCacheN _nod = new ZDDCacheN();
        ZDDCacheP _equ = new ZDDCacheP();
        ZDDCacheO _cru = new ZDDCacheO();
        ZDDCacheO _uni = new ZDDCacheO();
        ZDDCacheO _int = new ZDDCacheO();
        ZDDCacheO _dif = new ZDDCacheO();
        ZDDNumber zn = ZERO;
        while (i.hasNext()) {
            zn = ZDDNumber.addSubtrees(filter, i.next(), zn, _nod, _equ, _cru, _uni, _int, _dif);
        }
        return zn;
    }
}

