/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.ftod.zcube.zdd.ZDD;
import net.ftod.zcube.zdd.ZDDOperationCache;
import net.ftod.zcube.zdd.ZDDPredicateCache;
import net.ftod.zcube.zdd.ZDDTree;

final class ZDDTreePrefix
extends ZDDTree {
    private final String prefix;
    private final ZDDTree treeSet;

    ZDDTreePrefix(String prefix2, ZDDTree treeSet) {
        this.treeSet = treeSet;
        this.prefix = prefix2;
    }

    static ZDDTree _read(DataInputStream dis) throws IOException {
        String prefix2 = dis.readUTF();
        ZDDTree treeSet = ZDDTreePrefix.read(dis);
        return new ZDDTreePrefix(prefix2, treeSet);
    }

    protected void _write(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.prefix);
        this.treeSet.write(dos);
    }

    protected ZDD trees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h) {
        long h1 = ZDD.djb2(h, this.prefix);
        return ZDD.crossUnion(eq, cu, un, ZDD.singleton(h1), this.treeSet.trees(eq, cu, un, h1));
    }

    protected ZDD subtrees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h) {
        long h1 = ZDD.djb2(h, this.prefix);
        return ZDD.union(eq, un, ZDD.TOP, ZDD.crossUnion(eq, cu, un, ZDD.singleton(h1), this.treeSet.subtrees(eq, cu, un, h1)));
    }

    protected ZDDTree.Type type() {
        return ZDDTree.Type.Prefix;
    }
}

