/*
 * Decompiled with CFR 0.152.
 */
package net.ftod.zcube.zdd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.ftod.zcube.zdd.ZDD;
import net.ftod.zcube.zdd.ZDDOperationCache;
import net.ftod.zcube.zdd.ZDDPredicateCache;
import net.ftod.zcube.zdd.ZDDTreeCross;
import net.ftod.zcube.zdd.ZDDTreePrefix;
import net.ftod.zcube.zdd.ZDDTreeSum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZDDTree {
    public static final ZDDTree BOT = new ZDDTree(){

        protected ZDD trees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h) {
            return ZDD.BOT;
        }

        protected ZDD subtrees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h) {
            return ZDD.BOT;
        }

        protected Type type() {
            return Type.BOT;
        }

        protected void _write(DataOutputStream dos) throws IOException {
        }
    };
    public static final ZDDTree TOP = new ZDDTree(){

        protected ZDD trees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h) {
            return ZDD.TOP;
        }

        protected ZDD subtrees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h) {
            return ZDD.TOP;
        }

        protected Type type() {
            return Type.BOT;
        }

        protected void _write(DataOutputStream dos) throws IOException {
        }
    };

    public static ZDDTree prefix(String p, ZDDTree t) {
        return new ZDDTreePrefix(p, t);
    }

    public static ZDDTree prefix(ZDDTree t, String ... p) {
        return ZDDTree.prefix(Arrays.asList(p), t);
    }

    public static ZDDTree prefix(Iterable<String> p, ZDDTree t) {
        return ZDDTree.prefix(p.iterator(), t);
    }

    public static ZDDTree prefix(Iterator<String> p, ZDDTree t) {
        if (p.hasNext()) {
            return new ZDDTreePrefix(p.next(), ZDDTree.prefix(p, t));
        }
        return t;
    }

    public static ZDDTree path(String ... p) {
        return ZDDTree.path(Arrays.asList(p));
    }

    public static ZDDTree path(Iterable<String> p) {
        return ZDDTree.path(p.iterator());
    }

    public static ZDDTree path(Iterator<String> p) {
        return ZDDTree.prefix(p, TOP);
    }

    public static ZDDTree cross(ZDDTree ... ts) {
        return new ZDDTreeCross(ts);
    }

    public static ZDDTree cross(Collection<ZDDTree> ts) {
        return ZDDTree.cross(ZDDTree.array(ts));
    }

    public static ZDDTree sum(ZDDTree ... ts) {
        return new ZDDTreeSum(ts);
    }

    public static ZDDTree sum(Collection<ZDDTree> ts) {
        return ZDDTree.sum(ZDDTree.array(ts));
    }

    public static ZDD trees(ZDDTree t) {
        return ZDDTree.trees(t, new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache());
    }

    static ZDD trees(ZDDTree t, ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un) {
        return t.trees(eq, cu, un, 1L);
    }

    public static ZDD unionTrees(Collection<ZDDTree> ts) {
        return ZDDTree.unionTrees(ts, new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache());
    }

    static ZDD unionTrees(Collection<ZDDTree> ts, ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un) {
        int n = ts.size();
        ZDD[] zs = new ZDD[n];
        int i = 0;
        for (ZDDTree t : ts) {
            zs[i++] = ZDDTree.trees(t, eq, cu, un);
        }
        return ZDD.union(eq, un, zs);
    }

    public static ZDD subtrees(ZDDTree t) {
        return ZDDTree.subtrees(t, new ZDDPredicateCache(), new ZDDOperationCache(), new ZDDOperationCache());
    }

    static ZDD subtrees(ZDDTree t, ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un) {
        return t.subtrees(eq, cu, un, 1L);
    }

    public static ZDD subtrees(ZDD z, ZDDTree t) {
        ZDDPredicateCache eq = new ZDDPredicateCache();
        ZDDOperationCache cu = new ZDDOperationCache();
        ZDDOperationCache un = new ZDDOperationCache();
        ZDDOperationCache in = new ZDDOperationCache();
        return ZDD.intersection(eq, in, z, ZDDTree.subtrees(t, eq, cu, un));
    }

    protected abstract ZDD trees(ZDDPredicateCache var1, ZDDOperationCache var2, ZDDOperationCache var3, long var4);

    protected abstract ZDD subtrees(ZDDPredicateCache var1, ZDDOperationCache var2, ZDDOperationCache var3, long var4);

    protected static final ZDD[] mapTrees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h, ZDDTree[] ts) {
        int n = ts.length;
        ZDD[] zdds = new ZDD[n];
        int i = 0;
        while (i < n) {
            zdds[i] = ts[i].trees(eq, cu, un, h);
            ++i;
        }
        return zdds;
    }

    protected static final ZDD[] mapSubtrees(ZDDPredicateCache eq, ZDDOperationCache cu, ZDDOperationCache un, long h, ZDDTree[] ts) {
        int n = ts.length;
        ZDD[] zdds = new ZDD[n];
        int i = 0;
        while (i < n) {
            zdds[i] = ts[i].subtrees(eq, cu, un, h);
            ++i;
        }
        return zdds;
    }

    private static ZDDTree[] array(Collection<ZDDTree> c) {
        ZDDTree[] a = new ZDDTree[c.size()];
        c.toArray(a);
        return a;
    }

    protected abstract Type type();

    public static ZDDTree read(DataInputStream dis) throws IOException {
        return Type.values()[dis.readByte()].read(dis);
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type().ordinal());
        this._write(dos);
    }

    protected abstract void _write(DataOutputStream var1) throws IOException;

    public static ZDDTree[] readArray(DataInputStream dis) throws IOException {
        int length = dis.readInt();
        ZDDTree[] array = new ZDDTree[length];
        int i = 0;
        while (i < length) {
            array[i] = ZDDTree.read(dis);
            ++i;
        }
        return array;
    }

    public static void writeArray(ZDDTree[] ts, DataOutputStream dos) throws IOException {
        int length = ts.length;
        dos.writeInt(length);
        int i = 0;
        while (i < length) {
            ts[i].write(dos);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Type {
        BOT{

            protected ZDDTree read(DataInputStream dis) {
                return BOT;
            }
        }
        ,
        TOP{

            protected ZDDTree read(DataInputStream dis) {
                return TOP;
            }
        }
        ,
        Prefix{

            protected ZDDTree read(DataInputStream dis) throws IOException {
                return ZDDTreePrefix._read(dis);
            }
        }
        ,
        Cross{

            protected ZDDTree read(DataInputStream dis) throws IOException {
                return ZDDTreeCross._read(dis);
            }
        }
        ,
        Sum{

            protected ZDDTree read(DataInputStream dis) throws IOException {
                return ZDDTreeSum._read(dis);
            }
        };


        protected abstract ZDDTree read(DataInputStream var1) throws IOException;
    }
}

