/*
 * Decompiled with CFR 0.152.
 */
package net.james;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;

class JpegInfo {
    String Comment;
    public Image imageobj;
    public int imageHeight;
    public int imageWidth;
    public int[] BlockWidth;
    public int[] BlockHeight;
    public int Precision = 8;
    public int NumberOfComponents = 3;
    public Object[] Components;
    public int[] CompID = new int[]{1, 2, 3};
    public int[] HsampFactor = new int[]{2, 1, 1};
    public int[] VsampFactor = new int[]{2, 1, 1};
    public int[] QtableNumber = new int[]{0, 1, 1};
    public int[] DCtableNumber = new int[]{0, 1, 1};
    public int[] ACtableNumber = new int[]{0, 1, 1};
    public boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
    public boolean[] lastRowIsDummy = new boolean[]{false, false, false};
    public int Ss = 0;
    public int Se = 63;
    public int Ah = 0;
    public int Al = 0;
    public int[] compWidth;
    public int[] compHeight;
    public int MaxHsampFactor;
    public int MaxVsampFactor;

    public JpegInfo(Image image, String comment) {
        this.Components = new Object[this.NumberOfComponents];
        this.compWidth = new int[this.NumberOfComponents];
        this.compHeight = new int[this.NumberOfComponents];
        this.BlockWidth = new int[this.NumberOfComponents];
        this.BlockHeight = new int[this.NumberOfComponents];
        this.imageobj = image;
        this.imageWidth = image.getWidth(null);
        this.imageHeight = image.getHeight(null);
        this.Comment = comment;
        this.getYCCArray();
    }

    float[][] DownSample(float[][] C, int comp) {
        int inrow = 0;
        int incol = 0;
        float[][] output = new float[this.compHeight[comp]][this.compWidth[comp]];
        for (int outrow = 0; outrow < this.compHeight[comp]; ++outrow) {
            int bias = 1;
            for (int outcol = 0; outcol < this.compWidth[comp]; ++outcol) {
                float temp = C[inrow][incol++];
                temp += C[inrow++][incol--];
                temp += C[inrow][incol++];
                output[outrow][outcol] = (temp += C[inrow--][incol++] + (float)bias) / 4.0f;
                bias ^= 3;
            }
            inrow += 2;
            incol = 0;
        }
        return output;
    }

    public String getComment() {
        return this.Comment;
    }

    private void getYCCArray() {
        int y;
        int[] values = new int[this.imageWidth * this.imageHeight];
        PixelGrabber grabber = new PixelGrabber(this.imageobj.getSource(), 0, 0, this.imageWidth, this.imageHeight, values, 0, this.imageWidth);
        this.MaxHsampFactor = 1;
        this.MaxVsampFactor = 1;
        for (y = 0; y < this.NumberOfComponents; ++y) {
            this.MaxHsampFactor = Math.max(this.MaxHsampFactor, this.HsampFactor[y]);
            this.MaxVsampFactor = Math.max(this.MaxVsampFactor, this.VsampFactor[y]);
        }
        for (y = 0; y < this.NumberOfComponents; ++y) {
            this.compWidth[y] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.MaxHsampFactor * this.HsampFactor[y];
            if (this.compWidth[y] != this.imageWidth / this.MaxHsampFactor * this.HsampFactor[y]) {
                this.lastColumnIsDummy[y] = true;
            }
            this.BlockWidth[y] = (int)Math.ceil((double)this.compWidth[y] / 8.0);
            this.compHeight[y] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.MaxVsampFactor * this.VsampFactor[y];
            if (this.compHeight[y] != this.imageHeight / this.MaxVsampFactor * this.VsampFactor[y]) {
                this.lastRowIsDummy[y] = true;
            }
            this.BlockHeight[y] = (int)Math.ceil((double)this.compHeight[y] / 8.0);
        }
        try {
            if (!grabber.grabPixels()) {
                try {
                    throw new AWTException("Grabber returned false: " + grabber.getStatus());
                }
                catch (Exception exception) {}
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        float[][] Y = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cr1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb2 = new float[this.compHeight[1]][this.compWidth[1]];
        float[][] Cr2 = new float[this.compHeight[2]][this.compWidth[2]];
        int index = 0;
        for (y = 0; y < this.imageHeight; ++y) {
            for (int x = 0; x < this.imageWidth; ++x) {
                int r = values[index] >> 16 & 0xFF;
                int g = values[index] >> 8 & 0xFF;
                int b = values[index] & 0xFF;
                Y[y][x] = (float)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                Cb1[y][x] = 128.0f + (float)(-0.16874 * (double)r - 0.33126 * (double)g + 0.5 * (double)b);
                Cr1[y][x] = 128.0f + (float)(0.5 * (double)r - 0.41869 * (double)g - 0.08131 * (double)b);
                ++index;
            }
        }
        this.Components[0] = Y;
        Cb2 = this.DownSample(Cb1, 1);
        this.Components[1] = Cb2;
        Cr2 = this.DownSample(Cr1, 2);
        this.Components[2] = Cr2;
    }

    public void setComment(String comment) {
        this.Comment.concat(comment);
    }
}

