/*
 * Decompiled with CFR 0.152.
 */
package net.james;

import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.f5.crypt.F5Random;
import net.f5.crypt.Permutation;
import net.james.DCT;
import net.james.Huffman;
import net.james.JpegInfo;

public class JpegEncoder
extends Frame {
    Thread runner;
    BufferedOutputStream outStream;
    Image image;
    JpegInfo JpegObj;
    Huffman Huf;
    DCT dct;
    int imageHeight;
    int imageWidth;
    int Quality;
    int code;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    InputStream embeddedData = null;
    String password = null;
    int n = 0;

    public JpegEncoder(Image image, int quality, OutputStream out, String comment) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.Quality = quality;
        this.JpegObj = new JpegInfo(image, comment);
        this.imageHeight = this.JpegObj.imageHeight;
        this.imageWidth = this.JpegObj.imageWidth;
        this.outStream = new BufferedOutputStream(out);
        this.dct = new DCT(this.Quality);
        this.Huf = new Huffman(this.imageWidth, this.imageHeight);
    }

    public void Compress() {
        this.WriteHeaders(this.outStream);
        this.WriteCompressedData(this.outStream);
        this.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    public void Compress(InputStream embeddedData, String password) {
        this.embeddedData = embeddedData;
        this.password = password;
        this.Compress();
    }

    public int getQuality() {
        return this.Quality;
    }

    public void setQuality(int quality) {
        this.dct = new DCT(quality);
    }

    void WriteArray(byte[] data, BufferedOutputStream out) {
        try {
            int length = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF) + 2;
            out.write(data, 0, length);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    public void WriteCompressedData(BufferedOutputStream outStream) {
        int j;
        int i;
        int c;
        int r;
        int comp;
        boolean temp = false;
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[this.JpegObj.NumberOfComponents];
        int[] zeroArray = new int[64];
        int Width = 0;
        int Height = 0;
        boolean nothing = false;
        int MinBlockWidth = this.imageWidth % 8 != 0 ? (int)(Math.floor((double)this.imageWidth / 8.0) + 1.0) * 8 : this.imageWidth;
        int MinBlockHeight = this.imageHeight % 8 != 0 ? (int)(Math.floor((double)this.imageHeight / 8.0) + 1.0) * 8 : this.imageHeight;
        for (comp = 0; comp < this.JpegObj.NumberOfComponents; ++comp) {
            MinBlockWidth = Math.min(MinBlockWidth, this.JpegObj.BlockWidth[comp]);
            MinBlockHeight = Math.min(MinBlockHeight, this.JpegObj.BlockHeight[comp]);
        }
        int xpos = 0;
        int shuffledIndex = 0;
        int coeffCount = 0;
        for (r = 0; r < MinBlockHeight; ++r) {
            for (c = 0; c < MinBlockWidth; ++c) {
                for (comp = 0; comp < this.JpegObj.NumberOfComponents; ++comp) {
                    for (i = 0; i < this.JpegObj.VsampFactor[comp]; ++i) {
                        for (j = 0; j < this.JpegObj.HsampFactor[comp]; ++j) {
                            coeffCount += 64;
                        }
                    }
                }
            }
        }
        int[] coeff = new int[coeffCount];
        System.out.println("DCT/quantisation starts");
        System.out.println(this.imageWidth + " x " + this.imageHeight);
        for (r = 0; r < MinBlockHeight; ++r) {
            for (c = 0; c < MinBlockWidth; ++c) {
                xpos = c * 8;
                int ypos = r * 8;
                for (comp = 0; comp < this.JpegObj.NumberOfComponents; ++comp) {
                    Width = this.JpegObj.BlockWidth[comp];
                    Height = this.JpegObj.BlockHeight[comp];
                    float[][] inputArray = (float[][])this.JpegObj.Components[comp];
                    for (i = 0; i < this.JpegObj.VsampFactor[comp]; ++i) {
                        for (j = 0; j < this.JpegObj.HsampFactor[comp]; ++j) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            for (int a = 0; a < 8; ++a) {
                                for (int b = 0; b < 8; ++b) {
                                    int ia = ypos * this.JpegObj.VsampFactor[comp] + yblockoffset + a;
                                    int ib = xpos * this.JpegObj.HsampFactor[comp] + xblockoffset + b;
                                    if (this.imageHeight / 2 * this.JpegObj.VsampFactor[comp] <= ia) {
                                        ia = this.imageHeight / 2 * this.JpegObj.VsampFactor[comp] - 1;
                                    }
                                    if (this.imageWidth / 2 * this.JpegObj.HsampFactor[comp] <= ib) {
                                        ib = this.imageWidth / 2 * this.JpegObj.HsampFactor[comp] - 1;
                                    }
                                    dctArray1[a][b] = inputArray[ia][ib];
                                }
                            }
                            dctArray2 = this.dct.forwardDCT(dctArray1);
                            dctArray3 = this.dct.quantizeBlock(dctArray2, this.JpegObj.QtableNumber[comp]);
                            System.arraycopy(dctArray3, 0, coeff, shuffledIndex, 64);
                            shuffledIndex += 64;
                        }
                    }
                }
            }
        }
        System.out.println("got " + coeffCount + " DCT AC/DC coefficients");
        int _changed = 0;
        int _embedded = 0;
        int _examined = 0;
        int _expected = 0;
        int _one = 0;
        int _large = 0;
        int _thrown = 0;
        int _zero = 0;
        for (i = 0; i < coeffCount; ++i) {
            if (i % 64 == 0) continue;
            if (coeff[i] == 1) {
                ++_one;
            }
            if (coeff[i] == -1) {
                ++_one;
            }
            if (coeff[i] != 0) continue;
            ++_zero;
        }
        _large = coeffCount - _zero - _one - coeffCount / 64;
        _expected = _large + (int)(0.49 * (double)_one);
        System.out.println("one=" + _one);
        System.out.println("large=" + _large);
        System.out.println("expected capacity: " + _expected + " bits");
        System.out.println("expected capacity with");
        for (i = 1; i < 8; ++i) {
            int n = (1 << i) - 1;
            int usable = _expected * i / n - _expected * i / n % n;
            int changed = coeffCount - _zero - coeffCount / 64;
            changed = changed * i / n - changed * i / n % n;
            changed = n * changed / (n + 1) / i;
            changed = _large - _large % (n + 1);
            changed = (changed + _one + _one / 2 - _one / (n + 1)) / (n + 1);
            if ((usable /= 8) == 0) break;
            if (i == 1) {
                System.out.print("default");
            } else {
                System.out.print("(1, " + n + ", " + i + ")");
            }
            System.out.println(" code: " + usable + " bytes (efficiency: " + usable * 8 / changed + "." + usable * 80 / changed % 10 + " bits per change)");
        }
        if (this.embeddedData != null) {
            block66: {
                System.out.println("Permutation starts");
                F5Random random = new F5Random(this.password.getBytes());
                Permutation permutation = new Permutation(coeffCount, random);
                int nextBitToEmbed = 0;
                int byteToEmbed = 0;
                int availableBitsToEmbed = 0;
                try {
                    byteToEmbed = this.embeddedData.available();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.print("Embedding of " + (byteToEmbed * 8 + 32) + " bits (" + byteToEmbed + "+4 bytes) ");
                if (byteToEmbed > 0x7FFFFF) {
                    byteToEmbed = 0x7FFFFF;
                }
                for (i = 1; i < 8; ++i) {
                    this.n = (1 << i) - 1;
                    int usable = _expected * i / this.n - _expected * i / this.n % this.n;
                    if ((usable /= 8) == 0 || usable < byteToEmbed + 4) break;
                }
                int k = i - 1;
                this.n = (1 << k) - 1;
                switch (this.n) {
                    case 0: {
                        System.out.println("using default code, file will not fit");
                        ++this.n;
                        break;
                    }
                    case 1: {
                        System.out.println("using default code");
                        break;
                    }
                    default: {
                        System.out.println("using (1, " + this.n + ", " + k + ") code");
                    }
                }
                byteToEmbed |= k << 24;
                byteToEmbed ^= random.getNextByte();
                byteToEmbed ^= random.getNextByte() << 8;
                byteToEmbed ^= random.getNextByte() << 16;
                nextBitToEmbed = (byteToEmbed ^= random.getNextByte() << 24) & 1;
                byteToEmbed >>= 1;
                availableBitsToEmbed = 31;
                ++_embedded;
                if (this.n > 1) {
                    int[] codeWord = new int[this.n];
                    int startOfN = 0;
                    int endOfN = 0;
                    boolean isLastByte = false;
                    for (i = 0; i < coeffCount; ++i) {
                        shuffledIndex = permutation.getShuffled(i);
                        if (shuffledIndex % 64 == 0 || coeff[shuffledIndex] == 0) continue;
                        if (coeff[shuffledIndex] > 0) {
                            if ((coeff[shuffledIndex] & 1) != nextBitToEmbed) {
                                int n = shuffledIndex;
                                coeff[n] = coeff[n] - 1;
                                ++_changed;
                            }
                        } else if ((coeff[shuffledIndex] & 1) == nextBitToEmbed) {
                            int n = shuffledIndex;
                            coeff[n] = coeff[n] + 1;
                            ++_changed;
                        }
                        if (coeff[shuffledIndex] != 0) {
                            if (availableBitsToEmbed == 0) break;
                            nextBitToEmbed = byteToEmbed & 1;
                            byteToEmbed >>= 1;
                            --availableBitsToEmbed;
                            ++_embedded;
                            continue;
                        }
                        ++_thrown;
                    }
                    startOfN = i + 1;
                    do {
                        int kBitsToEmbed = 0;
                        for (i = 0; i < k; ++i) {
                            if (availableBitsToEmbed == 0) {
                                try {
                                    if (this.embeddedData.available() == 0) {
                                        isLastByte = true;
                                        break;
                                    }
                                    byteToEmbed = this.embeddedData.read();
                                    byteToEmbed ^= random.getNextByte();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break;
                                }
                                availableBitsToEmbed = 8;
                            }
                            nextBitToEmbed = byteToEmbed & 1;
                            byteToEmbed >>= 1;
                            --availableBitsToEmbed;
                            kBitsToEmbed |= nextBitToEmbed << i;
                            ++_embedded;
                        }
                        do {
                            j = startOfN;
                            i = 0;
                            while (i < this.n) {
                                if (j >= coeffCount) {
                                    System.out.println("Capacity exhausted.");
                                    break block66;
                                }
                                shuffledIndex = permutation.getShuffled(j);
                                if (shuffledIndex % 64 != 0 && coeff[shuffledIndex] != 0) {
                                    codeWord[i++] = shuffledIndex;
                                }
                                ++j;
                            }
                            endOfN = j;
                            int hash = 0;
                            for (i = 0; i < this.n; ++i) {
                                int extractedBit = coeff[codeWord[i]] > 0 ? coeff[codeWord[i]] & 1 : 1 - (coeff[codeWord[i]] & 1);
                                if (extractedBit != 1) continue;
                                hash ^= i + 1;
                            }
                            i = hash ^ kBitsToEmbed;
                            if (i == 0) break;
                            if (coeff[codeWord[--i]] > 0) {
                                int n = codeWord[i];
                                coeff[n] = coeff[n] - 1;
                            } else {
                                int n = codeWord[i];
                                coeff[n] = coeff[n] + 1;
                            }
                            ++_changed;
                            if (coeff[codeWord[i]] != 0) continue;
                            ++_thrown;
                        } while (coeff[codeWord[i]] == 0);
                        startOfN = endOfN;
                    } while (!isLastByte);
                } else {
                    for (i = 0; i < coeffCount; ++i) {
                        shuffledIndex = permutation.getShuffled(i);
                        if (shuffledIndex % 64 == 0 || coeff[shuffledIndex] == 0) continue;
                        ++_examined;
                        if (coeff[shuffledIndex] > 0) {
                            if ((coeff[shuffledIndex] & 1) != nextBitToEmbed) {
                                int n = shuffledIndex;
                                coeff[n] = coeff[n] - 1;
                                ++_changed;
                            }
                        } else if ((coeff[shuffledIndex] & 1) == nextBitToEmbed) {
                            int n = shuffledIndex;
                            coeff[n] = coeff[n] + 1;
                            ++_changed;
                        }
                        if (coeff[shuffledIndex] != 0) {
                            if (availableBitsToEmbed == 0) {
                                try {
                                    if (this.embeddedData.available() == 0) break;
                                    byteToEmbed = this.embeddedData.read();
                                    byteToEmbed ^= random.getNextByte();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    break;
                                }
                                availableBitsToEmbed = 8;
                            }
                            nextBitToEmbed = byteToEmbed & 1;
                            byteToEmbed >>= 1;
                            --availableBitsToEmbed;
                            ++_embedded;
                            continue;
                        }
                        ++_thrown;
                    }
                }
            }
            if (_examined > 0) {
                System.out.println(_examined + " coefficients examined");
            }
            System.out.println(_changed + " coefficients changed (efficiency: " + _embedded / _changed + "." + _embedded * 10 / _changed % 10 + " bits per change)");
            System.out.println(_thrown + " coefficients thrown (zeroed)");
            System.out.println(_embedded + " bits (" + _embedded / 8 + " bytes) embedded");
        }
        System.out.println("Starting Huffman Encoding.");
        shuffledIndex = 0;
        for (r = 0; r < MinBlockHeight; ++r) {
            for (c = 0; c < MinBlockWidth; ++c) {
                for (comp = 0; comp < this.JpegObj.NumberOfComponents; ++comp) {
                    for (i = 0; i < this.JpegObj.VsampFactor[comp]; ++i) {
                        for (j = 0; j < this.JpegObj.HsampFactor[comp]; ++j) {
                            System.arraycopy(coeff, shuffledIndex, dctArray3, 0, 64);
                            this.Huf.HuffmanBlockEncoder(outStream, dctArray3, lastDCvalue[comp], this.JpegObj.DCtableNumber[comp], this.JpegObj.ACtableNumber[comp]);
                            lastDCvalue[comp] = dctArray3[0];
                            shuffledIndex += 64;
                        }
                    }
                }
            }
        }
        this.Huf.flushBuffer(outStream);
    }

    public void WriteEOI(BufferedOutputStream out) {
        byte[] EOI = new byte[]{-1, -39};
        this.WriteMarker(EOI, out);
    }

    public void WriteHeaders(BufferedOutputStream out) {
        int j;
        int i;
        byte[] SOI = new byte[]{-1, -40};
        this.WriteMarker(SOI, out);
        byte[] JFIF = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0};
        if (this.JpegObj.getComment().equals("JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ")) {
            JFIF[10] = 0;
        }
        this.WriteArray(JFIF, out);
        String comment = new String();
        comment = this.JpegObj.getComment();
        int length = comment.length();
        if (length != 0) {
            byte[] COM = new byte[length + 4];
            COM[0] = -1;
            COM[1] = -2;
            COM[2] = (byte)(length >> 8 & 0xFF);
            COM[3] = (byte)(length & 0xFF);
            System.arraycopy(this.JpegObj.Comment.getBytes(), 0, COM, 4, this.JpegObj.Comment.length());
            this.WriteArray(COM, out);
        }
        byte[] DQT = new byte[134];
        DQT[0] = -1;
        DQT[1] = -37;
        DQT[2] = 0;
        DQT[3] = -124;
        int offset = 4;
        for (i = 0; i < 2; ++i) {
            DQT[offset++] = (byte)(0 + i);
            int[] tempArray = (int[])this.dct.quantum[i];
            for (j = 0; j < 64; ++j) {
                DQT[offset++] = (byte)tempArray[jpegNaturalOrder[j]];
            }
        }
        this.WriteArray(DQT, out);
        byte[] SOF = new byte[19];
        SOF[0] = -1;
        SOF[1] = -64;
        SOF[2] = 0;
        SOF[3] = 17;
        SOF[4] = (byte)this.JpegObj.Precision;
        SOF[5] = (byte)(this.JpegObj.imageHeight >> 8 & 0xFF);
        SOF[6] = (byte)(this.JpegObj.imageHeight & 0xFF);
        SOF[7] = (byte)(this.JpegObj.imageWidth >> 8 & 0xFF);
        SOF[8] = (byte)(this.JpegObj.imageWidth & 0xFF);
        SOF[9] = (byte)this.JpegObj.NumberOfComponents;
        int index = 10;
        for (i = 0; i < SOF[9]; ++i) {
            SOF[index++] = (byte)this.JpegObj.CompID[i];
            SOF[index++] = (byte)((this.JpegObj.HsampFactor[i] << 4) + this.JpegObj.VsampFactor[i]);
            SOF[index++] = (byte)this.JpegObj.QtableNumber[i];
        }
        this.WriteArray(SOF, out);
        length = 2;
        index = 4;
        int oldindex = 4;
        byte[] DHT1 = new byte[17];
        byte[] DHT4 = new byte[4];
        DHT4[0] = -1;
        DHT4[1] = -60;
        for (i = 0; i < 4; ++i) {
            int bytes = 0;
            DHT1[index++ - oldindex] = (byte)this.Huf.bits.elementAt(i)[0];
            for (j = 1; j < 17; ++j) {
                int temp = this.Huf.bits.elementAt(i)[j];
                DHT1[index++ - oldindex] = (byte)temp;
                bytes += temp;
            }
            int intermediateindex = index;
            byte[] DHT2 = new byte[bytes];
            for (j = 0; j < bytes; ++j) {
                DHT2[index++ - intermediateindex] = (byte)this.Huf.val.elementAt(i)[j];
            }
            byte[] DHT3 = new byte[index];
            System.arraycopy(DHT4, 0, DHT3, 0, oldindex);
            System.arraycopy(DHT1, 0, DHT3, oldindex, 17);
            System.arraycopy(DHT2, 0, DHT3, oldindex + 17, bytes);
            DHT4 = DHT3;
            oldindex = index;
        }
        DHT4[2] = (byte)(index - 2 >> 8 & 0xFF);
        DHT4[3] = (byte)(index - 2 & 0xFF);
        this.WriteArray(DHT4, out);
        byte[] SOS = new byte[14];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = 0;
        SOS[3] = 12;
        SOS[4] = (byte)this.JpegObj.NumberOfComponents;
        index = 5;
        for (i = 0; i < SOS[4]; ++i) {
            SOS[index++] = (byte)this.JpegObj.CompID[i];
            SOS[index++] = (byte)((this.JpegObj.DCtableNumber[i] << 4) + this.JpegObj.ACtableNumber[i]);
        }
        SOS[index++] = (byte)this.JpegObj.Ss;
        SOS[index++] = (byte)this.JpegObj.Se;
        SOS[index++] = (byte)((this.JpegObj.Ah << 4) + this.JpegObj.Al);
        this.WriteArray(SOS, out);
    }

    void WriteMarker(byte[] data, BufferedOutputStream out) {
        try {
            out.write(data, 0, 2);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }
}

