(ns blade.examples.victory
  (:use [blade :only [L]]))

; this is unfortunate and temporary until i split things out
(if L (do

(def tile-url
  "http://{s}.tile.cloudmade.com/5ecab6508db54f969c893eb1c6097d9b/{styleId}/256/{z}/{x}/{y}.png")
  ; "http://{s}.tile.cloudmade.com/BC9A493B41014CAABB98F0471D759707/997/256/{z}/{x}/{y}.png")

(def gmap (atom nil))

(defn reset []
  (.log js/console "view reset"))

(defn ^:export launch []
  (let [vlayer (L.LayerGroup.)
        graytiles    (-> L (.tileLayer tile-url {:styleId 22677}))
        ; mappy (-> L (.map "mappy")
        ;             (.setView [34.0086, -118.4986] 12))]
        mappy (-> L (.map "mappy" (clj->js {
          :center [34.0086, -118.4986]
          :zoom 12
          :layers [graytiles vlayer]
        })))]

    (reset! gmap mappy)

    (-> L (.-control) (.layers nil {:gray graytiles, :victory vlayer}) (.addTo mappy))
    ; var cities = new L.LayerGroup();

    ; (-> L (.tileLayer tile-url {
    ;           :maxZoom 18
    ;           :attribution "Map data &copy; <a href=\"http://openstreetmap.org\">OpenStreetMap</a> contributors, <a href=\"http://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, Imagery © <a href=\"http://cloudmade.com\">CloudMade</a>"})
    ;       (.addTo mappy))

    (.on mappy "viewreset" reset)
    (reset)

    (-> L (.marker [34.0086, -118.4986]) 
          (.addTo mappy)
          (.bindPopup "<b>Hello world!</b><br />I am a popup.")
          (.openPopup))

    (-> L (.circle [34.0286, -118.5486] 1000 {
              :color "red"
              :fillColor "#f03"
              :fillOpacity "0.5"})
          (.addTo vlayer)
          (.bindPopup "I am a circle."))

    (-> L (.polygon [
            [33.979, -118.48]
            [33.973, -118.46]
            [33.98, -118.447]])
          (.addTo vlayer)
          (.bindPopup "I am a <del>polygon</del> triangle"))))

    ; (let [popup (-> L .popup)]
    ;   (.on mappy "click" (fn [{:keys [latlng]} e]
    ;   (-> popup (.setLatLng latlng)
    ;             (.setContent (str "You clicked the map at " latlng))
    ;             (.openOn mappy)))))))

))