(ns net.dnolen.vecmath.Vector2d
  (:use net.dnolen.vecmath.core
        net.dnolen.vecmath.utils))

;; -----------------------------------------------------------------------------
;; Vector2d

(defrecord Vector2d
  [#^double x #^double y]

  VecMath
  (add [_ other] (Vector2d. (+ x (.x #^Vector2d other))
                        (+ y (.y #^Vector2d other))))

  (sub [_ other] (Vector2d. (- x (.x #^Vector2d other))
                        (- y (.y #^Vector2d other))))

  (mul [_ scalar] (let [scalar (double scalar)]
                    (Vector2d. (* x scalar) (* y scalar))))

  (div [_ scalar] (let [scalar (double scalar)]
                    (Vector2d. (/ x scalar) (/ y scalar))))

  (dist [_ other] (let [dx (double (- x (.x #^Vector2d other)))
                        dy (double (- y (.y #^Vector2d other)))]
                    (Math/sqrt (prim double + (* dx dx) (* dy dy)))))

  (dist-squared [_ other] (let [dx (double (- x (.x #^Vector2d other)))
                                dy (double (- y (.y #^Vector2d other)))]
                            (prim double + (* dx dx) (* dy dy))))

  (unit [_] (let [l (double (Math/sqrt (prim double + (* x x) (* y y))))]
              (Vector2d. (/ x l) (/ y l))))

  (perp [_] (Vector2d. (- y) x))

  (neg [_] (Vector2d. (* x (double -1.0)) (* y (double -1.0))))

  (length [_] (Math/sqrt (prim double + (* x x) (* y y))))

  (length-squared [_] (prim double + (* x x) (* y y))))

;; -----------------------------------------------------------------------------
;; Convenient values

(def zero (Vector2d. 0.0 0.0))
(def x-axis (Vector2d. 1.0 0.0))
(def y-axis (Vector2d. 1.0 0.0))