(ns net.cgrand.xforms.lens)

(defn seconds<>minutes
  "A lens that focuses on the minutes of an epoch of seconds."
  [functor f seconds]
    (->> seconds
      (* 1/60)              ; convert seconds into minutes
      f                     ; apply the function
      (functor #(* % 60)))) ; convert minutes back into seconds...
                            ; ...using a functor!

(defprotocol Lens
  (transverse [lens x xform]))

#_(extend-protocol Lens
   clojure.lang.Keyword
   (transverse [k m xform]
     (fn
       ([] (dissoc m k x))
       ([acc] acc)
       ([acc x] (assoc acc k x)))))

(defprotocol Dequeue
  (conjl [dq x])
  (peekl [dq])
  (popl [dq])
  (conjr [dq x])
  (peekr [dq])
  (popr [dq]))

;; the idea is to have

(deftype Digit [^objects digits ^int rot])

(deftype Node [^objects l m ^objects r ^int rot ^int cnt]
  Dequeue
  (conjl [dq x])
  (peekl [dq])
  (popl [dq])
  (conjr [dq x])
  (peekr [dq])
  (popr [dq])
  clojure.lang.Indexed
  (nth [n i]
    (let [ll (- (alength l) rot)
          rl (+ (alength r) rot)]
      (cond
        (< i ll) 
        )))
  (nth [n i not-found]
    ()))

