(ns draft
  (:require [net.cgrand.xforms :as x]))

(def Ø [[] nil 0 []])

(defn conjl [[l m r] x]
  (cond
    (< (count l) 32)
    [(vec (cons x l)) m r]
    (seq r)
    [[x] (conjl (or m Ø) l) r]
    :else [[x] nil l]))

(defn conjr [[l m r] x]
  (cond
    (< (count r) 32)
    [l m (conj r x)]
    (seq l)
    [l (conjr (or m Ø) r) [x]]
    :else
    [r nil [x]]))

(defn peekl [[l m r]]
  (if (seq l) 
    (nth l 0)
    (nth r 0)))

(defn peekr [[l m r]]
  (if (seq r)
    (peek r)
    (peek l)))

(defn popl [[l m r]]
  (cond
    (= [] l) [[] nil (vec (next r))]
    (next l)
      [(vec (next l)) m r]
    m
    [(peekl m) (popl m) r]
    :else
    [[] nil r]))

(defn popr [[l m r]]
  (cond
    (= [] r) [(pop l) nil []]
    (seq (pop r))
      [l m (pop r)]
    m
    [l (popr m) (peekr m)]
    :else
    [l nil []]))