(ns useragent.os)

(defn os [family version]
  {:os-family family :os-version version})

(defn parse [user-agent-string]
  (condp re-find user-agent-string

    ;; Bot
    #"Googlebot/([0-9.]+);" :>> #(os "Googlebot" (second %))
    #"HatenaScreenshot" (os "HetenaScreenshot" nil)


    ;; MacOS
    #"Mac OS X[ /_]([0-9]+)[._]([0-9]+)[._]([0-9]+)" :>> #(os "MacOS X" (str (second %) "." (nth % 2) "." (nth % 3)))
    #"Mac OS X[ /_]([0-9]+)[._]([0-9]+)"             :>> #(os "MacOS X" (str (second %) "." (nth % 2)))
    #"Mac 10.([0-9.]+)"                              :>> #(os "MacOS X" (second %))

    #"Darwin[ ]?([0-9.]+)" :>> #(os "Darwin" (second %))
    #"Darwin"                   (os "Darwin"      nil)
    #"Mac(_Power|intosh.+P)PC"  (os "MacOS PPC"   nil)

    ;; Mobile
    #"Android ([0-9.]+)"                         :>> #(os "Android"       (second %))
    #"i(Phone|Pod|Pad).*OS[ /]([0-9]+)_([0-9]+)" :>> #(os "iOS"           (str (nth % 2) "." (nth % 3)))
    #"i(Phone|Pod|Pad)"                               (os "iOS"           nil)
    #"XBLWP7"                                         (os "Windows Phone" nil)

    ;; Windows
    #"Windows NT 6\.3"                             (os "Windows" "8.1")
    #"Windows NT 6\.2; ARM;"                       (os "Windows" "RT")
    #"Windows NT 6\.2"                             (os "Windows" "8")
    #"(Windows NT 6\.1|Windows 7)"                 (os "Windows" "7")
    #"Windows (NT 6\.0|Vista)"                     (os "Windows" "Vista")
    #"Windows (2003|NT[ /]?5\.2).*(WOW64|Win64)"   (os "Windows" "XP (64-bit)")
    #"Windows (2003|NT[ /]?5\.2)"                  (os "Windows" "2003")
    #"Windows NT 5\.1"                             (os "Windows" "XP")
    #"Windows (2000|NT[ /]?5\.0)"                  (os "Windows" "2000")
    #"wi(n|ndows)[ \-]?nt[ /]?([0-4][0-9.]+)" :>> #(os "Windows NT" (nth % 2))
    #"wi(n|ndows)[ \-][ /]?([0-4][0-9.]+)"    :>> #(os "Windows NT" (nth % 2))
    #"wi(n|ndows)[ \-]?nt"                         (os "Windows NT" nil)

    ;; Linux
    #"Ubuntu/([0-9.]+)"          :>> #(os "Ubuntu Linux" (second %))
    #"Ubuntu"                         (os "Ubuntu Linux" nil)
    #"Arch Linux"                     (os "Arch Linux"   nil)
    #"gentoo"                         (os "Gentoo Linux" nil)
    #"el([0-9.]{1}).*centos"     :>> #(os "CentOS" (second %))
    #"Fedora/[0-9.-]+fc([0-9]+)" :>> #(os "Fedora" (second %))
    #"Fedora"                    :>> #(os "Fedora" (second %))
    #"Linux Mint[/ ]?([0-9.]+)?" :>> #(os "Linux Mint"  (second %))
    #"Mandriva[ /]([0-9.]+)"     :>> #(os "Mandriva"  (second %))
    #"Linux[ /\-]([0-9.-]+).mdk"      (os "Mandriva"  nil)
    #"Linux[ /\-]([0-9.-]+).mdv" :>> #(os "Mandriva"  (second %))
    #"PCLinuxOS[ /]?([0-9.]+)"   :>> #(os "PCLinuxOS" (second %))
    #"Debian"                         (os "Debian"    nil)
    #"Linux[ /\-]([a-z0-9._]+)"  :>> #(os "Linux"     (second %))

    ;; BSD
    #"free[ \-]?bsd[ /]([a-z0-9._]+)" :>> #(os "FreeBSD" (second %))
    #"free[ \-]?bsd"                  :>> #(os "FreeBSD" nil)
    #"net[ \-]?bsd[ /]([a-z0-9._]+)"  :>> #(os "NetBSD"  (second %))
    #"net[ \-]?bsd"                   :>> #(os "NetBSD"  nil)
    #"open[ \-]?bsd[ /]([a-z0-9._]+)" :>> #(os "OpenBSD" (second %))
    #"open[ \-]?bsd"                  :>> #(os "OpenBSD" nil)

        ;; other
    (os "other" nil)))

