(ns useragent.browser)


(defn browser [family version]
  {:browser-family family
   :browser-version version})

(defn parse [user-agent-string]
  (condp re-find user-agent-string

    ;; Bot
    #"Googlebot/([0-9.]+);" :>> #(browser "Googlebot" (second %))
    #"HatenaScreenshot" (browser "HatenaScreenshot" nil)

    #"(Chrome|Chromium)/(\d+)\.(\d+)\.(\d+)" :>> #(browser (second %) (str (nth % 2) "." (nth % 3) "." (nth % 4)))
    #"Firefox/([0-9.+]{1,10})"           :>> #(browser "Firefox" (second %))
    #"Version/([0-9.]{1,10})(.*)Safari"  :>> #(browser "Safari"  (second %))
    #"Safari[ /]?([0-9.]{1,10})"         :>> #(browser "Safari"  (second %))
    #"opera.+Version[ /]([x0-9.]{1,10})" :>> #(browser "Opera"   (second %))
    #"opera[ /]([0-9.]{1,10})"           :>> #(browser "Opera"   (second %))
    #"Reeder/([0-9.+]{1,10})"            :>> #(browser "Reeder"  (second %))

    ;; Other WebKit and Mozilla
    #"AppleWebKit/([0-9.]{1,10}).*Gecko"                   :>> #(browser "Webkit"  (second %))
    #"^mozilla/[5-9]\.[0-9.]{1,10}.+rv:([0-9a-z.+]{1,10})" :>> #(browser "Mozilla" (second %))
    #"^mozilla/([5-9]\.[0-9a-z.]{1,10})"                   :>> #(browser "Mozilla" (second %))
    #"GNUzilla/([0-9.+]{1,10})"                            :>> #(browser "Mozilla" (second %))

    ;; Chrome Frame must come before MSIE
    #"chromeframe/(\d+)\.(\d+)\.(\d+)" :>> #(browser "Chrome Frame" (str (second %) "." (nth % 2) "." (nth % 3)))

    ;; IE
    #".*Trident/7.0.*rv:([0-9.]+).*"           :>> #(browser "IE" (second %)) ;; IE 11
    #".*MSIE 7.0.*Trident.*"                   :>> #(browser "IE" "text:8.0 (MSIE 7.0)")
    #"\(compatible; MSIE[ /]([0-9a-z.]{1,10})" :>> #(browser "IE" (second %))
    #"MSIE[ /]([0-9a-z.]{1,3})"                :>> #(browser "IE" (second %))
    #"Internet Explorer[ /]([0-9.]{1,10})"     :>> #(browser "IE" (second %))
    #"^Auto-Proxy Downloader"                       (browser "IE" nil)

    ;; Other
    #"camino/([0-9.+]{1,10})"                   :>> #(browser "Camino"          (second %))
    #"Crazy Browser[ /]([0-9.]{1,10})"          :>> #(browser "Crazy Browser"   (second %))
    #"curl[ /]([0-9.]{1,10})"                   :>> #(browser "Curl"            (second %))
    #"Epiphany/([0-9.]{1,10})"                  :>> #(browser "epiphany-webkit" (second %))
    #"Iceweasel/([0-9.+]{1,10})"                :>> #(browser "Iceweasel"       (second %))
    #"Lunascape[ /]([0-9a-z.]{1,10})"           :>> #(browser "Lunascape"       (second %))
    #"lynx/([0-9a-z.]{1,10})"                   :>> #(browser "Lynx"            (second %))
    #"NetNewsWire[ /]([0-9.]{1,10})"            :>> #(browser "NetNewsWire"     (second %))
    #"NetFront[ /]([0-9.]{1,10})"               :>> #(browser "NetFront"        (second %))
    #"opera mini[ /]([0-9.]{1,10})"             :>> #(browser "Opera Mini"      (second %))
    #"Seamonkey[ \-/]([0-9a-z.]{1,10})"         :>> #(browser "SeaMonkey"       (second %))
    #"Sleipnir( Version)?[ /]([0-9a-z.]{1,10})" :>> #(browser "Sleipnir"        (nth % 2))
    #"w3m/([0-9.]{1,10})"                       :>> #(browser "w3m"             (second %))

    ;; condp else
    (browser "other" nil)))

