;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

  (ns antifessional.libmisc.debug
    "helper functions for tracing, debuging, etc.
    
    ![](images/antifessional.libmisc.debug.png)
    "
    (:require 
     [clojure.string :as str]
     ))



(defn log
  "logs with println or js/console as necessary"
  [& strs]
  (let [o (apply str strs)]
    #?(:cljs
       (.log js/console o)
       :clj 
       (println o))))


